/*
 * Decompiled with CFR 0.152.
 */
package com.hrb.library;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.os.IBinder;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.hrb.library.MediaService;
import com.hrb.library.R;

public class MiniMusicView
extends FrameLayout
implements MediaService.IMediaStateListener,
ServiceConnection {
    private final String TAG = "MiniMusicView";
    private Context mContext;
    private ViewStub mViewStub;
    private RelativeLayout mLayout;
    private ImageView mIcon;
    private ImageView mControlBtn;
    private ProgressBar mLoadMusic;
    private TextView mMusicTitle;
    private TextView mMusicAuthor;
    private ProgressBar mProgressBar;
    private boolean mIsAddView;
    private boolean mIsPlay;
    private OnMusicStateListener mMusicStateListener;
    private OnNextButtonClickListener mNextButtonClickListener;
    private HeadsetPlugReceiver mHeadsetPlugReceiver;
    private int mMusicDuration;
    private boolean mIsPlayComplete;
    private String mCurPlayUrl;
    private MediaService mediaService;

    public MiniMusicView(Context context) {
        this(context, null);
    }

    public MiniMusicView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MiniMusicView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.mIsAddView = false;
        this.mIsPlay = true;
        this.mIsPlayComplete = false;
        this.initView();
        this.initAttributeSet(attrs);
    }

    private void initAttributeSet(AttributeSet attrs) {
        Drawable iconDrawable;
        if (attrs == null) {
            return;
        }
        TypedArray arr = this.mContext.obtainStyledAttributes(attrs, R.styleable.MiniMusicView);
        boolean isLoadLayout = arr.getBoolean(R.styleable.MiniMusicView_isLoadLayout, false);
        if (isLoadLayout) {
            this.initDefaultView();
        }
        int titleColor = arr.getColor(R.styleable.MiniMusicView_titleColor, Color.parseColor((String)"#000000"));
        this.setTitleColor(titleColor);
        int titleSize = arr.getDimensionPixelOffset(R.styleable.MiniMusicView_titleTextSize, -1);
        if (titleSize != -1) {
            this.setTitleTextSize(titleSize);
        }
        int bgColor = arr.getColor(R.styleable.MiniMusicView_musicBackgroundColor, Color.parseColor((String)"#eeeeee"));
        this.setMusicBackgroundColor(bgColor);
        Drawable progressDrawable = arr.getDrawable(R.styleable.MiniMusicView_progressDrawable);
        if (progressDrawable != null) {
            this.setProgressDrawable(progressDrawable);
        }
        if ((iconDrawable = arr.getDrawable(R.styleable.MiniMusicView_musicIcon)) != null) {
            this.setIconDrawable(iconDrawable);
        }
        arr.recycle();
    }

    private void initView() {
        View.inflate((Context)this.mContext, (int)R.layout.layout_default_viewstup, (ViewGroup)this);
        this.mViewStub = (ViewStub)this.findViewById(R.id.vs_mini_view);
        this.initReceiver();
    }

    public void initDefaultView() {
        if (this.mViewStub != null) {
            View view = this.mViewStub.inflate();
            this.mLayout = (RelativeLayout)view.findViewById(R.id.ll_layout);
            this.mIcon = (ImageView)view.findViewById(R.id.iv_music_icon);
            this.mControlBtn = (ImageView)view.findViewById(R.id.iv_control_btn);
            ImageView mNextBtn = (ImageView)view.findViewById(R.id.iv_next_btn);
            this.mLoadMusic = (ProgressBar)view.findViewById(R.id.pb_loading);
            this.mMusicTitle = (TextView)view.findViewById(R.id.tv_music_title);
            this.mMusicAuthor = (TextView)view.findViewById(R.id.tv_music_author);
            this.mProgressBar = (ProgressBar)view.findViewById(R.id.pb_progress);
            this.mControlBtn.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    MiniMusicView.this.controlBtnClick();
                }
            });
            mNextBtn.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (MiniMusicView.this.mNextButtonClickListener != null) {
                        MiniMusicView.this.mNextButtonClickListener.OnClick();
                    }
                }
            });
            this.mViewStub = null;
        }
    }

    private void initReceiver() {
        if (this.mHeadsetPlugReceiver == null) {
            this.mHeadsetPlugReceiver = new HeadsetPlugReceiver();
        }
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.media.AUDIO_BECOMING_NOISY");
        this.mContext.registerReceiver((BroadcastReceiver)this.mHeadsetPlugReceiver, intentFilter);
    }

    private void controlBtnClick() {
        if (this.mIsPlay) {
            this.pausePlayMusic();
            this.changeControlBtnState(false);
        } else {
            if (!this.mIsPlayComplete) {
                this.resumePlayMusic();
            } else {
                this.startPlayMusic(this.mCurPlayUrl);
                this.mProgressBar.setProgress(0);
                this.mIsPlayComplete = false;
            }
            this.changeControlBtnState(true);
        }
        Log.i((String)"MiniMusicView", (String)("controlBtnClick: isPlay=" + this.mIsPlay));
    }

    public void addView(View child) {
        this.removeAllViews();
        super.addView(child);
        this.mIsAddView = true;
        Log.d((String)"MiniMusicView", (String)("addView: [ " + this.hashCode() + " ]"));
    }

    private void changeLoadingMusicState(boolean isLoading) {
        if (!this.mIsAddView) {
            if (isLoading) {
                this.mLoadMusic.setVisibility(0);
                this.mControlBtn.setVisibility(8);
            } else {
                this.mLoadMusic.setVisibility(8);
                this.mControlBtn.setVisibility(0);
            }
        }
    }

    public void changeControlBtnState(boolean isPlay) {
        if (!this.mIsAddView && this.mControlBtn != null) {
            if (isPlay) {
                this.mControlBtn.setImageResource(R.drawable.mini_btn_pause);
                this.mIsPlay = true;
            } else {
                this.mControlBtn.setImageResource(R.drawable.mini_btn_play);
                this.mIsPlay = false;
            }
        }
    }

    public void setOnMusicStateListener(OnMusicStateListener listener) {
        this.mMusicStateListener = listener;
    }

    public void setOnNextBtnClickListener(OnNextButtonClickListener listener) {
        this.mNextButtonClickListener = listener;
    }

    public void startPlayMusic(String path) {
        this.mCurPlayUrl = path;
        this.changeLoadingMusicState(true);
        this.changeControlBtnState(true);
        if (this.mediaService == null) {
            Intent intent = new Intent(this.mContext, MediaService.class);
            this.mContext.bindService(intent, (ServiceConnection)this, 1);
        } else {
            this.mediaService.playMusic(this.mCurPlayUrl);
        }
        Log.d((String)"MiniMusicView", (String)("startPlayMusic: [ " + this.hashCode() + " ]"));
    }

    public void resumePlayMusic() {
        if (this.mediaService != null) {
            this.mediaService.resumeMusic(this.mCurPlayUrl);
        }
        Log.d((String)"MiniMusicView", (String)("resumePlayMusic: [ " + this.hashCode() + " ]"));
    }

    public void pausePlayMusic() {
        if (this.mediaService != null) {
            this.mediaService.pauseMusic();
        }
        Log.d((String)"MiniMusicView", (String)("pausePlayMusic: [ " + this.hashCode() + " ]"));
    }

    public void seekToMusic(int pos) {
        if (this.mediaService != null) {
            this.mediaService.seekToMusic(pos);
        }
        Log.d((String)"MiniMusicView", (String)("seekToMusic: pos = " + pos));
    }

    public void stopPlayMusic() {
        this.mContext.unbindService((ServiceConnection)this);
        if (this.mHeadsetPlugReceiver != null) {
            this.mContext.unregisterReceiver((BroadcastReceiver)this.mHeadsetPlugReceiver);
        }
        this.mContext = null;
        Log.d((String)"MiniMusicView", (String)("stopPlayMusic: [ " + this.hashCode() + " ]"));
    }

    public void setTitleColor(int color) {
        if (!this.mIsAddView && this.mMusicTitle != null) {
            this.mMusicTitle.setTextColor(color);
        }
    }

    public void setTitleTextSize(int dimen) {
        if (!this.mIsAddView && this.mMusicTitle != null) {
            this.mMusicTitle.setTextSize(0, (float)dimen);
        }
    }

    public void setMusicBackgroundColor(int color) {
        if (!this.mIsAddView && this.mLayout != null) {
            this.mLayout.setBackgroundColor(color);
        }
    }

    public void setIconDrawable(Drawable background) {
        if (!this.mIsAddView && this.mIcon != null) {
            this.mIcon.setImageDrawable(background);
        }
    }

    public void setProgressDrawable(Drawable drawable2) {
        if (!this.mIsAddView && this.mProgressBar != null) {
            this.mProgressBar.setProgressDrawable(drawable2);
        }
    }

    public void setProgressMax(int max) {
        if (!this.mIsAddView && this.mProgressBar != null) {
            this.mProgressBar.setMax(max);
        }
    }

    public void setProgress(int progress) {
        if (!this.mIsAddView && this.mProgressBar != null) {
            this.mProgressBar.setProgress(progress);
        }
    }

    public void setTitleText(String text) {
        if (!this.mIsAddView && this.mMusicTitle != null) {
            this.mMusicTitle.setText((CharSequence)text);
        }
    }

    public void setAuthor(String text) {
        if (!this.mIsAddView && this.mMusicAuthor != null) {
            this.mMusicAuthor.setText((CharSequence)text);
        }
    }

    public boolean isPlaying() {
        return this.mIsPlay;
    }

    public int getMusicDuration() {
        return this.mMusicDuration;
    }

    @Override
    public void onPrepared(int duration) {
        this.mMusicDuration = duration;
        if (this.mMusicStateListener != null) {
            this.mMusicStateListener.onPrepared(this.mMusicDuration);
        }
        this.changeLoadingMusicState(false);
        this.setProgressMax(this.mMusicDuration);
        Log.d((String)"MiniMusicView", (String)"onPrepared: STATE_MUSIC_PREPARE");
    }

    @Override
    public void onProgressUpdate(int currentPos, int duration) {
        if (this.mMusicStateListener != null) {
            this.mMusicStateListener.onProgressUpdate(duration, currentPos);
        }
        this.setProgress(currentPos);
    }

    @Override
    public void onSeekComplete() {
        if (this.mMusicStateListener != null) {
            this.mMusicStateListener.onSeekComplete();
        }
        Log.d((String)"MiniMusicView", (String)"onSeekComplete: STATE_SEEK_COMPLETE");
    }

    @Override
    public void onCompletion() {
        this.mIsPlayComplete = true;
        this.changeControlBtnState(false);
        if (this.mMusicStateListener != null) {
            this.mMusicStateListener.onMusicPlayComplete();
        }
        Log.d((String)"MiniMusicView", (String)"onCompletion: STATE_PLAY_COMPLETE");
    }

    @Override
    public boolean onInfo(int what, int extra) {
        if (what == 701) {
            this.changeLoadingMusicState(true);
            Log.i((String)"MiniMusicView", (String)"MEDIA_INFO_BUFFERING_START");
        } else if (what == 702) {
            this.changeLoadingMusicState(false);
            Log.i((String)"MiniMusicView", (String)"MEDIA_INFO_BUFFERING_END");
        }
        if (this.mMusicStateListener != null) {
            this.mMusicStateListener.onInfo(what, extra);
        }
        return false;
    }

    @Override
    public boolean onError(int what, int extra) {
        if (this.mMusicStateListener != null) {
            this.mMusicStateListener.onError(what, extra);
        }
        if (!this.mIsAddView) {
            Toast.makeText((Context)this.mContext, (CharSequence)this.getResources().getString(R.string.load_error), (int)0).show();
            this.mLoadMusic.setVisibility(8);
            if (this.mControlBtn.getVisibility() != 0) {
                this.mControlBtn.setVisibility(0);
            }
            this.changeControlBtnState(false);
        }
        Log.d((String)"MiniMusicView", (String)"onError: STATE_PLAY_ERROR");
        return false;
    }

    public void onServiceConnected(ComponentName name, IBinder service) {
        Log.i((String)"MiniMusicView", (String)("onServiceConnected: [ " + this.hashCode() + " ]"));
        MediaService.MediaBinder mediaBinder = (MediaService.MediaBinder)service;
        this.mediaService = mediaBinder.getService();
        this.mediaService.setMediaStateListener(this);
        if (!TextUtils.isEmpty((CharSequence)this.mCurPlayUrl) && this.mediaService != null) {
            this.mediaService.playMusic(this.mCurPlayUrl);
        }
    }

    public void onServiceDisconnected(ComponentName name) {
    }

    private class HeadsetPlugReceiver
    extends BroadcastReceiver {
        private HeadsetPlugReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.media.AUDIO_BECOMING_NOISY".equals(action) && MiniMusicView.this.mIsPlay) {
                if (MiniMusicView.this.mMusicStateListener != null) {
                    MiniMusicView.this.mMusicStateListener.onHeadsetPullOut();
                }
                MiniMusicView.this.pausePlayMusic();
                if (!MiniMusicView.this.mIsAddView) {
                    MiniMusicView.this.changeControlBtnState(false);
                }
            }
            Log.d((String)"MiniMusicView", (String)"onReceive: ===HeadsetPullout===");
        }
    }

    public static interface OnNextButtonClickListener {
        public void OnClick();
    }

    public static interface OnMusicStateListener {
        public void onPrepared(int var1);

        public void onError(int var1, int var2);

        public void onInfo(int var1, int var2);

        public void onMusicPlayComplete();

        public void onSeekComplete();

        public void onProgressUpdate(int var1, int var2);

        public void onHeadsetPullOut();
    }
}

