/*
 * Decompiled with CFR 0.152.
 */
package com.hrb.library;

import android.app.Service;
import android.content.Intent;
import android.media.MediaPlayer;
import android.os.AsyncTask;
import android.os.Binder;
import android.os.IBinder;
import android.os.SystemClock;
import android.text.TextUtils;

public class MediaService
extends Service
implements MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnBufferingUpdateListener,
MediaPlayer.OnSeekCompleteListener,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnInfoListener {
    private static MediaPlayer mMediaPlayer;
    private int mCurrPlayPosition = 0;
    private String mPlayUrl;
    private static ProgressTask mProgressTask;
    private boolean mIsStart = false;
    private MediaBinder mBinder = new MediaBinder();
    private IMediaStateListener mMediaStateListener;

    public IBinder onBind(Intent intent) {
        return this.mBinder;
    }

    public void onCreate() {
        super.onCreate();
        if (mMediaPlayer == null) {
            mMediaPlayer = new MediaPlayer();
            mMediaPlayer.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
            mMediaPlayer.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)this);
            mMediaPlayer.setOnErrorListener((MediaPlayer.OnErrorListener)this);
            mMediaPlayer.setOnSeekCompleteListener((MediaPlayer.OnSeekCompleteListener)this);
            mMediaPlayer.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
            mMediaPlayer.setOnInfoListener((MediaPlayer.OnInfoListener)this);
        }
    }

    public void playMusic(String path) {
        if (mMediaPlayer != null) {
            try {
                mMediaPlayer.reset();
                mMediaPlayer.setDataSource(path);
                mMediaPlayer.prepareAsync();
                if (mProgressTask == null) {
                    mProgressTask = new ProgressTask();
                    mProgressTask.execute(new Void[0]);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setMediaStateListener(IMediaStateListener listener) {
        this.mMediaStateListener = listener;
    }

    public void pauseMusic() {
        this.mCurrPlayPosition = mMediaPlayer.getCurrentPosition();
        if (mMediaPlayer != null && mMediaPlayer.isPlaying()) {
            mMediaPlayer.pause();
        }
    }

    public void resumeMusic(String playPath) {
        this.playerToPosition(this.mCurrPlayPosition);
        if (TextUtils.isEmpty((CharSequence)this.mPlayUrl)) {
            this.mPlayUrl = playPath;
            this.playMusic(this.mPlayUrl);
        } else {
            mMediaPlayer.start();
        }
    }

    private void stopMusic() {
        if (mMediaPlayer != null) {
            mMediaPlayer.stop();
            mMediaPlayer.release();
            mMediaPlayer = null;
        }
    }

    private void playerToPosition(int CurrPlayPosition) {
        if (CurrPlayPosition > 0 && CurrPlayPosition < mMediaPlayer.getDuration()) {
            mMediaPlayer.seekTo(CurrPlayPosition);
        }
    }

    public void onDestroy() {
        this.stopMusic();
        if (mProgressTask != null) {
            mProgressTask.stopProgressUpdate();
            mProgressTask = null;
        }
        super.onDestroy();
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        return super.onStartCommand(intent, flags, startId);
    }

    public void onCompletion(MediaPlayer mediaPlayer) {
        if (this.mMediaStateListener != null) {
            this.mMediaStateListener.onCompletion();
        }
    }

    public void onBufferingUpdate(MediaPlayer mediaPlayer, int i) {
    }

    public boolean onError(MediaPlayer mediaPlayer, int what, int extra) {
        if (this.mMediaStateListener != null) {
            this.mMediaStateListener.onError(what, extra);
        }
        return false;
    }

    public boolean onInfo(MediaPlayer mp, int what, int extra) {
        if (this.mMediaStateListener != null) {
            this.mMediaStateListener.onInfo(what, extra);
        }
        return false;
    }

    public void onSeekComplete(MediaPlayer mediaPlayer) {
        if (this.mMediaStateListener != null) {
            this.mMediaStateListener.onSeekComplete();
        }
    }

    public void onPrepared(MediaPlayer mediaPlayer) {
        mediaPlayer.start();
        if (this.mMediaStateListener != null) {
            this.mMediaStateListener.onPrepared(mMediaPlayer.getDuration());
        }
        this.mIsStart = true;
    }

    public void seekToMusic(int pos) {
        if (mMediaPlayer != null && this.mIsStart && pos < mMediaPlayer.getDuration()) {
            mMediaPlayer.seekTo(pos);
        }
    }

    static interface IMediaStateListener {
        public void onPrepared(int var1);

        public void onProgressUpdate(int var1, int var2);

        public void onSeekComplete();

        public void onCompletion();

        public boolean onInfo(int var1, int var2);

        public boolean onError(int var1, int var2);
    }

    private class ProgressTask
    extends AsyncTask<Void, Void, Void> {
        private boolean mIsUpdate = true;

        private ProgressTask() {
        }

        protected Void doInBackground(Void ... params) {
            while (this.mIsUpdate) {
                SystemClock.sleep((long)1000L);
                this.publishProgress(new Void[0]);
            }
            return null;
        }

        protected void onProgressUpdate(Void ... values) {
            if (mMediaPlayer != null && mMediaPlayer.isPlaying() && MediaService.this.mMediaStateListener != null) {
                MediaService.this.mMediaStateListener.onProgressUpdate(mMediaPlayer.getCurrentPosition(), mMediaPlayer.getDuration());
            }
            super.onProgressUpdate((Object[])values);
        }

        void stopProgressUpdate() {
            this.mIsUpdate = false;
        }
    }

    class MediaBinder
    extends Binder {
        MediaBinder() {
        }

        MediaService getService() {
            return MediaService.this;
        }
    }
}

