/*
 * Decompiled with CFR 0.152.
 */
package com.hrb.library;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.hrb.library.MediaService;
import com.hrb.library.R;

public class MiniMusicView
extends FrameLayout {
    private final String TAG = "MiniMusicView";
    private Context mContext;
    private ViewStub mViewStub;
    private RelativeLayout mLayout;
    private ImageView mIcon;
    private ImageView mControlBtn;
    private ProgressBar mLoadMusic;
    private TextView mMusicTitle;
    private TextView mMusicAuthor;
    private ProgressBar mProgressBar;
    private boolean mIsAddView;
    private Intent mServiceIntent;
    private Intent mPauseIntent;
    private Intent mResumeIntent;
    private boolean mIsPlay;
    private MusicStateUpdateReceiver mMusicUpdateReceiver;
    private OnMusicStateListener mMusicStateListener;
    private OnNextButtonClickListener mNextButtonClickListener;
    private HeadsetPlugReceiver mHeadsetPlugReceiver;
    private int mMusicDuration;
    private boolean mIsPlayComplete;
    private String mCurPlayUrl;

    public MiniMusicView(Context context) {
        this(context, null);
    }

    public MiniMusicView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MiniMusicView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.mIsAddView = false;
        this.mIsPlay = true;
        this.mIsPlayComplete = false;
        this.initView();
        this.initAttributeSet(attrs);
    }

    private void initAttributeSet(AttributeSet attrs) {
        Drawable iconDrawable;
        if (attrs == null) {
            return;
        }
        TypedArray arr = this.mContext.obtainStyledAttributes(attrs, R.styleable.MiniMusicView);
        boolean isLoadLayout = arr.getBoolean(R.styleable.MiniMusicView_isLoadLayout, false);
        if (isLoadLayout) {
            this.initDefaultView();
        }
        int titleColor = arr.getColor(R.styleable.MiniMusicView_titleColor, Color.parseColor((String)"#000000"));
        this.setTitleColor(titleColor);
        int titleSize = arr.getDimensionPixelOffset(R.styleable.MiniMusicView_titleTextSize, -1);
        if (titleSize != -1) {
            this.setTitleTextSize(titleSize);
        }
        int bgColor = arr.getColor(R.styleable.MiniMusicView_musicBackgroundColor, Color.parseColor((String)"#eeeeee"));
        this.setMusicBackgroundColor(bgColor);
        Drawable progressDrawable = arr.getDrawable(R.styleable.MiniMusicView_progressDrawable);
        if (progressDrawable != null) {
            this.setProgressDrawable(progressDrawable);
        }
        if ((iconDrawable = arr.getDrawable(R.styleable.MiniMusicView_musicIcon)) != null) {
            this.setIconDrawable(iconDrawable);
        }
        arr.recycle();
    }

    private void initView() {
        View.inflate((Context)this.mContext, (int)R.layout.layout_default_viewstup, (ViewGroup)this);
        this.mViewStub = (ViewStub)this.findViewById(R.id.vs_mini_view);
        this.initReceiver();
    }

    public void initDefaultView() {
        if (this.mViewStub != null) {
            View view = this.mViewStub.inflate();
            this.mLayout = (RelativeLayout)view.findViewById(R.id.ll_layout);
            this.mIcon = (ImageView)view.findViewById(R.id.iv_music_icon);
            this.mControlBtn = (ImageView)view.findViewById(R.id.iv_control_btn);
            ImageView mNextBtn = (ImageView)view.findViewById(R.id.iv_next_btn);
            this.mLoadMusic = (ProgressBar)view.findViewById(R.id.pb_loading);
            this.mMusicTitle = (TextView)view.findViewById(R.id.tv_music_title);
            this.mMusicAuthor = (TextView)view.findViewById(R.id.tv_music_author);
            this.mProgressBar = (ProgressBar)view.findViewById(R.id.pb_progress);
            this.mControlBtn.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    MiniMusicView.this.controlBtnClick();
                }
            });
            mNextBtn.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (MiniMusicView.this.mNextButtonClickListener != null) {
                        MiniMusicView.this.mNextButtonClickListener.OnClick();
                    }
                }
            });
            this.mViewStub = null;
        }
    }

    private void initReceiver() {
        this.mMusicUpdateReceiver = new MusicStateUpdateReceiver();
        IntentFilter filter = new IntentFilter();
        filter.addAction("com.mini.media.music.state.action");
        this.mContext.registerReceiver((BroadcastReceiver)this.mMusicUpdateReceiver, filter);
        this.registerHeadsetPlugReceiver();
    }

    private void registerHeadsetPlugReceiver() {
        this.mHeadsetPlugReceiver = new HeadsetPlugReceiver();
        IntentFilter intentFilter = new IntentFilter("android.media.AUDIO_BECOMING_NOISY");
        this.mContext.registerReceiver((BroadcastReceiver)this.mHeadsetPlugReceiver, intentFilter);
    }

    private void controlBtnClick() {
        if (this.mIsPlay) {
            this.pausePlayMusic();
            this.changeControlBtnState(false);
        } else {
            if (!this.mIsPlayComplete) {
                this.resumePlayMusic();
            } else {
                this.startPlayMusic(this.mCurPlayUrl);
                this.mProgressBar.setProgress(0);
                this.mIsPlayComplete = false;
            }
            this.changeControlBtnState(true);
        }
        Log.i((String)"MiniMusicView", (String)("controlBtnClick: isPlay=" + this.mIsPlay));
    }

    public void addView(View child) {
        this.removeAllViews();
        super.addView(child);
        this.mIsAddView = true;
        Log.d((String)"MiniMusicView", (String)("addView: [ " + ((Object)((Object)this)).hashCode() + " ]"));
    }

    private void changeLoadingMusicState(boolean isLoading) {
        if (!this.mIsAddView) {
            if (isLoading) {
                this.mLoadMusic.setVisibility(0);
                this.mControlBtn.setVisibility(8);
            } else {
                this.mLoadMusic.setVisibility(8);
                this.mControlBtn.setVisibility(0);
            }
        }
    }

    public void changeControlBtnState(boolean isPlay) {
        if (!this.mIsAddView && this.mControlBtn != null) {
            if (isPlay) {
                this.mControlBtn.setImageResource(R.drawable.mini_btn_pause);
                this.mIsPlay = true;
            } else {
                this.mControlBtn.setImageResource(R.drawable.mini_btn_play);
                this.mIsPlay = false;
            }
        }
    }

    public void setOnMusicStateListener(OnMusicStateListener listener) {
        this.mMusicStateListener = listener;
    }

    public void setOnNextBtnClickListener(OnNextButtonClickListener listener) {
        this.mNextButtonClickListener = listener;
    }

    public void startPlayMusic(String path) {
        this.mCurPlayUrl = path;
        this.changeLoadingMusicState(true);
        this.changeControlBtnState(true);
        if (this.mServiceIntent == null) {
            this.mServiceIntent = new Intent(this.mContext, MediaService.class);
            this.mServiceIntent.putExtra("option", 0);
            this.mServiceIntent.putExtra("playUrl", path);
            this.mContext.startService(this.mServiceIntent);
        } else {
            Intent playIntent = new Intent();
            playIntent.setAction("com.mini.media.service.action");
            playIntent.putExtra("option", 0);
            playIntent.putExtra("playUrl", path);
            this.mContext.sendBroadcast(playIntent);
        }
        Log.d((String)"MiniMusicView", (String)("startPlayMusic: [ " + ((Object)((Object)this)).hashCode() + " ]"));
    }

    public void resumePlayMusic() {
        if (this.mResumeIntent == null) {
            this.mResumeIntent = new Intent();
            this.mResumeIntent.setAction("com.mini.media.service.action");
            this.mResumeIntent.putExtra("option", 2);
        }
        this.mContext.sendBroadcast(this.mResumeIntent);
        Log.d((String)"MiniMusicView", (String)("resumePlayMusic: [ " + ((Object)((Object)this)).hashCode() + " ]"));
    }

    public void pausePlayMusic() {
        if (this.mPauseIntent == null) {
            this.mPauseIntent = new Intent();
            this.mPauseIntent.setAction("com.mini.media.service.action");
            this.mPauseIntent.putExtra("option", 1);
        }
        this.mContext.sendBroadcast(this.mPauseIntent);
        Log.d((String)"MiniMusicView", (String)("pausePlayMusic: [ " + ((Object)((Object)this)).hashCode() + " ]"));
    }

    public void seekToMusic(int pos) {
        Intent intent = new Intent();
        intent.setAction("com.mini.media.service.action");
        intent.putExtra("option", 3);
        intent.putExtra("seekPos", pos);
        this.mContext.sendBroadcast(intent);
        Log.d((String)"MiniMusicView", (String)("seekToMusic: pos = " + pos));
    }

    public void stopPlayMusic() {
        if (this.mServiceIntent != null) {
            this.mContext.stopService(this.mServiceIntent);
        }
        if (this.mMusicUpdateReceiver != null) {
            this.mContext.unregisterReceiver((BroadcastReceiver)this.mMusicUpdateReceiver);
        }
        if (this.mHeadsetPlugReceiver != null) {
            this.mContext.unregisterReceiver((BroadcastReceiver)this.mHeadsetPlugReceiver);
        }
        Log.d((String)"MiniMusicView", (String)("stopPlayMusic: [ " + ((Object)((Object)this)).hashCode() + " ]"));
    }

    public void setTitleColor(int color) {
        if (!this.mIsAddView && this.mMusicTitle != null) {
            this.mMusicTitle.setTextColor(color);
        }
    }

    public void setTitleTextSize(int dimen) {
        if (!this.mIsAddView && this.mMusicTitle != null) {
            this.mMusicTitle.setTextSize(0, (float)dimen);
        }
    }

    public void setMusicBackgroundColor(int color) {
        if (!this.mIsAddView && this.mLayout != null) {
            this.mLayout.setBackgroundColor(color);
        }
    }

    public void setIconDrawable(Drawable background) {
        if (!this.mIsAddView && this.mIcon != null) {
            this.mIcon.setImageDrawable(background);
        }
    }

    public void setProgressDrawable(Drawable drawable2) {
        if (!this.mIsAddView && this.mProgressBar != null) {
            this.mProgressBar.setProgressDrawable(drawable2);
        }
    }

    public void setProgressMax(int max) {
        if (!this.mIsAddView && this.mProgressBar != null) {
            this.mProgressBar.setMax(max);
        }
    }

    public void setProgress(int progress) {
        if (!this.mIsAddView && this.mProgressBar != null) {
            this.mProgressBar.setProgress(progress);
        }
    }

    public void setTitleText(String text) {
        if (!this.mIsAddView && this.mMusicTitle != null) {
            this.mMusicTitle.setText((CharSequence)text);
        }
    }

    public void setAuthor(String text) {
        if (!this.mIsAddView && this.mMusicAuthor != null) {
            this.mMusicAuthor.setText((CharSequence)text);
        }
    }

    public boolean isPlaying() {
        return this.mIsPlay;
    }

    public int getMusicDuration() {
        return this.mMusicDuration;
    }

    private class HeadsetPlugReceiver
    extends BroadcastReceiver {
        private HeadsetPlugReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.media.AUDIO_BECOMING_NOISY".equals(action) && MiniMusicView.this.mIsPlay) {
                if (MiniMusicView.this.mMusicStateListener != null) {
                    MiniMusicView.this.mMusicStateListener.onHeadsetPullOut();
                }
                if (!MiniMusicView.this.mIsAddView) {
                    MiniMusicView.this.pausePlayMusic();
                    MiniMusicView.this.changeControlBtnState(false);
                }
            }
            Log.d((String)"MiniMusicView", (String)"onReceive: ===HeadsetPullout===");
        }
    }

    public class MusicStateUpdateReceiver
    extends BroadcastReceiver {
        public void onReceive(Context context, Intent intent) {
            int state = intent.getIntExtra("state", -1);
            switch (state) {
                case 4: {
                    MiniMusicView.this.mIsPlayComplete = true;
                    MiniMusicView.this.changeControlBtnState(false);
                    if (MiniMusicView.this.mMusicStateListener != null) {
                        MiniMusicView.this.mMusicStateListener.onMusicPlayComplete();
                    }
                    Log.d((String)"MiniMusicView", (String)"onReceive: STATE_PLAY_COMPLETE");
                    break;
                }
                case 5: {
                    int what = intent.getIntExtra("what", 0);
                    int extra = intent.getIntExtra("extra", 0);
                    if (MiniMusicView.this.mMusicStateListener != null) {
                        MiniMusicView.this.mMusicStateListener.onError(what, extra);
                    }
                    if (!MiniMusicView.this.mIsAddView) {
                        Toast.makeText((Context)MiniMusicView.this.mContext, (CharSequence)MiniMusicView.this.getResources().getString(R.string.load_error), (int)0).show();
                        MiniMusicView.this.mLoadMusic.setVisibility(8);
                        if (MiniMusicView.this.mControlBtn.getVisibility() != 0) {
                            MiniMusicView.this.mControlBtn.setVisibility(0);
                        }
                        MiniMusicView.this.changeControlBtnState(false);
                    }
                    Log.d((String)"MiniMusicView", (String)"onReceive: STATE_PLAY_ERROR");
                    break;
                }
                case 9: {
                    int what1 = intent.getIntExtra("what", 0);
                    int extra1 = intent.getIntExtra("extra", 0);
                    if (what1 == 701) {
                        MiniMusicView.this.changeLoadingMusicState(true);
                        Log.i((String)"MiniMusicView", (String)"MEDIA_INFO_BUFFERING_START");
                    } else if (what1 == 702) {
                        MiniMusicView.this.changeLoadingMusicState(false);
                        Log.i((String)"MiniMusicView", (String)"MEDIA_INFO_BUFFERING_END");
                    }
                    if (MiniMusicView.this.mMusicStateListener == null) break;
                    MiniMusicView.this.mMusicStateListener.onInfo(what1, extra1);
                    break;
                }
                case 6: {
                    if (MiniMusicView.this.mMusicStateListener != null) {
                        MiniMusicView.this.mMusicStateListener.onSeekComplete();
                    }
                    Log.d((String)"MiniMusicView", (String)"onReceive: STATE_SEEK_COMPLETE");
                    break;
                }
                case 8: {
                    MiniMusicView.this.mMusicDuration = intent.getIntExtra("duration", -1);
                    if (MiniMusicView.this.mMusicStateListener != null) {
                        MiniMusicView.this.mMusicStateListener.onPrepared(MiniMusicView.this.mMusicDuration);
                    }
                    MiniMusicView.this.changeLoadingMusicState(false);
                    MiniMusicView.this.setProgressMax(MiniMusicView.this.mMusicDuration);
                    Log.d((String)"MiniMusicView", (String)"onReceive: STATE_MUSIC_PREPARE");
                    break;
                }
                case 7: {
                    int duration = intent.getIntExtra("duration", 0);
                    int currentPos = intent.getIntExtra("currentPos", 0);
                    if (MiniMusicView.this.mMusicStateListener != null) {
                        MiniMusicView.this.mMusicStateListener.onProgressUpdate(duration, currentPos);
                    }
                    MiniMusicView.this.setProgress(currentPos);
                    break;
                }
            }
        }
    }

    public static interface OnNextButtonClickListener {
        public void OnClick();
    }

    public static interface OnMusicStateListener {
        public void onPrepared(int var1);

        public void onError(int var1, int var2);

        public void onInfo(int var1, int var2);

        public void onMusicPlayComplete();

        public void onSeekComplete();

        public void onProgressUpdate(int var1, int var2);

        public void onHeadsetPullOut();
    }
}

