/*
 * Decompiled with CFR 0.152.
 */
package com.hrb.library;

import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.MediaPlayer;
import android.os.AsyncTask;
import android.os.IBinder;
import android.os.SystemClock;
import android.text.TextUtils;

public class MediaService
extends Service
implements MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnBufferingUpdateListener,
MediaPlayer.OnSeekCompleteListener,
MediaPlayer.OnPreparedListener {
    public static final int OPTION_PLAY = 0;
    public static final int OPTION_PAUSE = 1;
    public static final int OPTION_CONTINUE = 2;
    public static final int OPTION_SEEK = 3;
    public static final int STATE_PLAY_COMPLETE = 4;
    public static final int STATE_PLAY_ERROR = 5;
    public static final int STATE_SEEK_COMPLETE = 6;
    public static final int STATE_PROGRESS_UPDATE = 7;
    public static final int STATE_MUSIC_PREPARE = 8;
    public static final String MUSIC_SERVICE_ACTION = "com.mini.media.service.action";
    public static final String MUSIC_STATE_ACTION = "com.mini.media.music.state.action";
    private static MediaPlayer mMediaPlayer;
    private MusicServiceReceiver mMusicServiceReceiver;
    private int mCurrPlayPosition = 0;
    private String mPlayUrl;
    private static ProgressTask mProgressTask;
    private boolean mIsStart = false;

    public IBinder onBind(Intent intent) {
        return null;
    }

    public void onCreate() {
        super.onCreate();
        if (mMediaPlayer == null) {
            mMediaPlayer = new MediaPlayer();
            mMediaPlayer.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
            mMediaPlayer.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)this);
            mMediaPlayer.setOnErrorListener((MediaPlayer.OnErrorListener)this);
            mMediaPlayer.setOnSeekCompleteListener((MediaPlayer.OnSeekCompleteListener)this);
            mMediaPlayer.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
        }
        if (this.mMusicServiceReceiver == null) {
            this.mMusicServiceReceiver = new MusicServiceReceiver();
            IntentFilter filter = new IntentFilter();
            filter.addAction(MUSIC_SERVICE_ACTION);
            this.registerReceiver(this.mMusicServiceReceiver, filter);
        }
    }

    private void playMusic(String path) {
        if (mMediaPlayer != null) {
            try {
                mMediaPlayer.reset();
                mMediaPlayer.setDataSource(path);
                mMediaPlayer.prepareAsync();
                if (mProgressTask == null) {
                    mProgressTask = new ProgressTask();
                    mProgressTask.execute(new Void[0]);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void pauseMusic() {
        if (mMediaPlayer != null && mMediaPlayer.isPlaying()) {
            mMediaPlayer.pause();
        }
    }

    private void resumeMusic(String playPath) {
        this.playerToPosition(this.mCurrPlayPosition);
        if (TextUtils.isEmpty((CharSequence)this.mPlayUrl)) {
            this.mPlayUrl = playPath;
            this.playMusic(this.mPlayUrl);
        } else {
            mMediaPlayer.start();
        }
    }

    private void stopMusic() {
        if (mMediaPlayer != null) {
            mMediaPlayer.stop();
            mMediaPlayer.release();
            mMediaPlayer = null;
        }
    }

    private void playerToPosition(int CurrPlayPosition) {
        if (CurrPlayPosition > 0 && CurrPlayPosition < mMediaPlayer.getDuration()) {
            mMediaPlayer.seekTo(CurrPlayPosition);
        }
    }

    public void onDestroy() {
        this.stopMusic();
        this.unregisterReceiver(this.mMusicServiceReceiver);
        if (mProgressTask != null) {
            mProgressTask.stopProgressUpdate();
            mProgressTask = null;
        }
        super.onDestroy();
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        Intent mediaIntent = new Intent();
        mediaIntent.setAction(MUSIC_SERVICE_ACTION);
        mediaIntent.putExtra("option", intent.getIntExtra("option", -1));
        mediaIntent.putExtra("playUrl", intent.getStringExtra("playUrl"));
        this.sendBroadcast(mediaIntent);
        return super.onStartCommand(intent, flags, startId);
    }

    public void onCompletion(MediaPlayer mediaPlayer) {
        Intent intent = new Intent();
        intent.setAction(MUSIC_STATE_ACTION);
        intent.putExtra("state", 4);
        this.sendBroadcast(intent);
    }

    public void onBufferingUpdate(MediaPlayer mediaPlayer, int i) {
    }

    public boolean onError(MediaPlayer mediaPlayer, int i, int i1) {
        Intent intent = new Intent();
        intent.setAction(MUSIC_STATE_ACTION);
        intent.putExtra("state", 5);
        this.sendBroadcast(intent);
        return false;
    }

    public void onSeekComplete(MediaPlayer mediaPlayer) {
        Intent intent = new Intent();
        intent.setAction(MUSIC_STATE_ACTION);
        intent.putExtra("state", 6);
        this.sendBroadcast(intent);
    }

    public void onPrepared(MediaPlayer mediaPlayer) {
        mediaPlayer.start();
        Intent intent = new Intent();
        intent.setAction(MUSIC_STATE_ACTION);
        intent.putExtra("state", 8);
        intent.putExtra("duration", mMediaPlayer.getDuration());
        this.sendBroadcast(intent);
        this.mIsStart = true;
    }

    private void seekToMusic(int pos) {
        if (mMediaPlayer != null && this.mIsStart && pos < mMediaPlayer.getDuration()) {
            mMediaPlayer.seekTo(pos);
        }
    }

    private class ProgressTask
    extends AsyncTask<Void, Void, Void> {
        private boolean mIsUpdate = true;

        private ProgressTask() {
        }

        protected Void doInBackground(Void ... params) {
            while (this.mIsUpdate) {
                SystemClock.sleep((long)1000L);
                this.publishProgress(new Void[0]);
            }
            return null;
        }

        protected void onProgressUpdate(Void ... values) {
            if (mMediaPlayer != null && mMediaPlayer.isPlaying()) {
                Intent intent = new Intent();
                intent.setAction(MediaService.MUSIC_STATE_ACTION);
                intent.putExtra("state", 7);
                intent.putExtra("currentPos", mMediaPlayer.getCurrentPosition());
                intent.putExtra("duration", mMediaPlayer.getDuration());
                MediaService.this.sendBroadcast(intent);
            }
            super.onProgressUpdate((Object[])values);
        }

        public void stopProgressUpdate() {
            this.mIsUpdate = false;
        }
    }

    private class MusicServiceReceiver
    extends BroadcastReceiver {
        private MusicServiceReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            int option = intent.getIntExtra("option", -1);
            switch (option) {
                case 0: {
                    MediaService.this.mPlayUrl = intent.getStringExtra("playUrl");
                    MediaService.this.playMusic(MediaService.this.mPlayUrl);
                    break;
                }
                case 1: {
                    MediaService.this.mCurrPlayPosition = mMediaPlayer.getCurrentPosition();
                    MediaService.this.pauseMusic();
                    break;
                }
                case 2: {
                    String path = intent.getStringExtra("playUrl");
                    MediaService.this.resumeMusic(path);
                    break;
                }
                case 3: {
                    int pos = intent.getIntExtra("seekPos", 0);
                    MediaService.this.seekToMusic(pos);
                    break;
                }
            }
        }
    }
}

