/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.internal;

import android.animation.TimeInterpolator;
import android.content.res.ColorStateList;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.os.Build;
import android.text.TextPaint;
import android.text.TextUtils;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.math.MathUtils;
import androidx.core.text.TextDirectionHeuristicsCompat;
import androidx.core.view.GravityCompat;
import androidx.core.view.ViewCompat;
import com.google.android.material.animation.AnimationUtils;
import com.google.android.material.resources.CancelableFontCallback;
import com.google.android.material.resources.TextAppearance;
import com.google.android.material.resources.TextAppearanceFontCallback;

public final class CollapsingTextHelper2 {
    private static final boolean USE_SCALING_TEXTURE = Build.VERSION.SDK_INT < 18;
    private static final boolean DEBUG_DRAW = false;
    @NonNull
    private static final Paint DEBUG_DRAW_PAINT = null;
    private final View view;
    private boolean drawTitle;
    private float expandedFraction;
    @NonNull
    private final Rect expandedBounds;
    @NonNull
    private final Rect collapsedBounds;
    @NonNull
    private final RectF currentBounds;
    private int expandedTextGravity = 16;
    private int collapsedTextGravity = 16;
    private float expandedTextSize;
    private float expandedTextSize2 = 15.0f;
    private float collapsedTextSize;
    private float collapsedTextSize2 = 15.0f;
    private ColorStateList expandedTextColor;
    private ColorStateList expandedTextColor2;
    private ColorStateList collapsedTextColor;
    private ColorStateList collapsedTextColor2;
    private float expandedDrawY;
    private float expandedDrawY2;
    private float collapsedDrawY;
    private float collapsedDrawY2;
    private float expandedDrawX;
    private float expandedDrawX2;
    private float collapsedDrawX;
    private float collapsedDrawX2;
    private float currentDrawX;
    private float currentDrawX2;
    private float currentDrawY;
    private float currentDrawY2;
    private Typeface collapsedTypeface;
    private Typeface collapsedTypeface2;
    private Typeface expandedTypeface;
    private Typeface expandedTypeface2;
    private Typeface currentTypeface;
    private Typeface currentTypeface2;
    private CancelableFontCallback expandedFontCallback;
    private CancelableFontCallback expandedFontCallback2;
    private CancelableFontCallback collapsedFontCallback;
    private CancelableFontCallback collapsedFontCallback2;
    @Nullable
    private CharSequence text;
    @Nullable
    private CharSequence text2;
    @Nullable
    private CharSequence textToDraw;
    @Nullable
    private CharSequence textToDraw2;
    private boolean isRtl;
    private boolean useTexture;
    @Nullable
    private Bitmap expandedTitleTexture;
    @Nullable
    private Bitmap expandedTitleTexture2;
    private Paint texturePaint;
    private Paint texturePaint2;
    private float textureAscent;
    private float textureAscent2;
    private float textureDescent;
    private float textureDescent2;
    private float scale;
    private float scale2;
    private float currentTextSize;
    private float currentTextSize2;
    private int[] state;
    private boolean boundsChanged;
    @NonNull
    private final TextPaint textPaint;
    @NonNull
    private final TextPaint textPaint2;
    @NonNull
    private final TextPaint tmpPaint;
    @NonNull
    private final TextPaint tmpPaint2;
    private TimeInterpolator positionInterpolator;
    private TimeInterpolator textSizeInterpolator;
    private float collapsedShadowRadius;
    private float collapsedShadowRadius2;
    private float collapsedShadowDx;
    private float collapsedShadowDx2;
    private float collapsedShadowDy;
    private float collapsedShadowDy2;
    private ColorStateList collapsedShadowColor;
    private ColorStateList collapsedShadowColor2;
    private float expandedShadowRadius;
    private float expandedShadowRadius2;
    private float expandedShadowDx;
    private float expandedShadowDx2;
    private float expandedShadowDy;
    private float expandedShadowDy2;
    private ColorStateList expandedShadowColor;
    private ColorStateList expandedShadowColor2;

    public CollapsingTextHelper2(View view) {
        this.view = view;
        this.textPaint = new TextPaint(129);
        this.textPaint2 = new TextPaint(129);
        this.tmpPaint = new TextPaint((Paint)this.textPaint);
        this.tmpPaint2 = new TextPaint((Paint)this.textPaint2);
        this.collapsedBounds = new Rect();
        this.expandedBounds = new Rect();
        this.currentBounds = new RectF();
    }

    public void setTextSizeInterpolator(TimeInterpolator interpolator) {
        this.textSizeInterpolator = interpolator;
        this.recalculate();
    }

    public void setPositionInterpolator(TimeInterpolator interpolator) {
        this.positionInterpolator = interpolator;
        this.recalculate();
    }

    public void setExpandedTextSize(float textSize) {
        if (this.expandedTextSize != textSize) {
            this.expandedTextSize = textSize;
            this.recalculate();
        }
    }

    public void setExpandedTextSize2(float textSize) {
        if (this.expandedTextSize2 != textSize) {
            this.expandedTextSize2 = textSize;
            this.recalculate();
        }
    }

    public void setCollapsedTextSize(float textSize) {
        if (this.collapsedTextSize != textSize) {
            this.collapsedTextSize = textSize;
            this.recalculate();
        }
    }

    public void setCollapsedTextSize2(float textSize) {
        if (this.collapsedTextSize2 != textSize) {
            this.collapsedTextSize2 = textSize;
            this.recalculate();
        }
    }

    public void setCollapsedTextColor(ColorStateList textColor) {
        if (this.collapsedTextColor != textColor) {
            this.collapsedTextColor = textColor;
            this.recalculate();
        }
    }

    public void setCollapsedTextColor2(ColorStateList textColor) {
        if (this.collapsedTextColor2 != textColor) {
            this.collapsedTextColor2 = textColor;
            this.recalculate();
        }
    }

    public void setExpandedTextColor(ColorStateList textColor) {
        if (this.expandedTextColor != textColor) {
            this.expandedTextColor = textColor;
            this.recalculate();
        }
    }

    public void setExpandedTextColor2(ColorStateList textColor) {
        if (this.expandedTextColor2 != textColor) {
            this.expandedTextColor2 = textColor;
            this.recalculate();
        }
    }

    public void setExpandedBounds(int left, int top, int right, int bottom) {
        if (!CollapsingTextHelper2.rectEquals(this.expandedBounds, left, top, right, bottom)) {
            this.expandedBounds.set(left, top, right, bottom);
            this.boundsChanged = true;
            this.onBoundsChanged();
        }
    }

    public void setExpandedBounds(@NonNull Rect bounds) {
        this.setExpandedBounds(bounds.left, bounds.top, bounds.right, bounds.bottom);
    }

    public void setCollapsedBounds(int left, int top, int right, int bottom) {
        if (!CollapsingTextHelper2.rectEquals(this.collapsedBounds, left, top, right, bottom)) {
            this.collapsedBounds.set(left, top, right, bottom);
            this.boundsChanged = true;
            this.onBoundsChanged();
        }
    }

    public void setCollapsedBounds(@NonNull Rect bounds) {
        this.setCollapsedBounds(bounds.left, bounds.top, bounds.right, bounds.bottom);
    }

    public void getCollapsedTextActualBounds(@NonNull RectF bounds) {
        boolean isRtl = this.calculateIsRtl(this.text);
        bounds.left = !isRtl ? (float)this.collapsedBounds.left : (float)this.collapsedBounds.right - this.calculateCollapsedTextWidth();
        bounds.top = this.collapsedBounds.top;
        bounds.right = !isRtl ? bounds.left + this.calculateCollapsedTextWidth() : (float)this.collapsedBounds.right;
        bounds.bottom = (float)this.collapsedBounds.top + this.getCollapsedTextHeight();
    }

    public void getCollapsedTextActualBounds2(@NonNull RectF bounds) {
        boolean isRtl = this.calculateIsRtl(this.text2);
        bounds.left = !isRtl ? (float)this.collapsedBounds.left : (float)this.collapsedBounds.right - this.calculateCollapsedTextWidth2();
        bounds.top = this.collapsedBounds.top;
        bounds.right = !isRtl ? bounds.left + this.calculateCollapsedTextWidth2() : (float)this.collapsedBounds.right;
        bounds.bottom = (float)this.collapsedBounds.top + this.getCollapsedTextHeight2();
    }

    public float calculateCollapsedTextWidth() {
        if (this.text == null) {
            return 0.0f;
        }
        this.getTextPaintCollapsed(this.tmpPaint);
        return this.tmpPaint.measureText(this.text, 0, this.text.length());
    }

    public float calculateCollapsedTextWidth2() {
        if (this.text2 == null) {
            return 0.0f;
        }
        this.getTextPaintCollapsed2(this.tmpPaint2);
        return this.tmpPaint2.measureText(this.text2, 0, this.text2.length());
    }

    public float getExpandedTextHeight() {
        this.getTextPaintExpanded(this.tmpPaint);
        return -this.tmpPaint.ascent();
    }

    public float getExpandedTextHeight2() {
        this.getTextPaintExpanded2(this.tmpPaint2);
        return -this.tmpPaint2.ascent();
    }

    public float getCollapsedTextHeight() {
        this.getTextPaintCollapsed(this.tmpPaint);
        return -this.tmpPaint.ascent();
    }

    public float getCollapsedTextHeight2() {
        this.getTextPaintCollapsed2(this.tmpPaint2);
        return -this.tmpPaint2.ascent();
    }

    private void getTextPaintExpanded(@NonNull TextPaint textPaint) {
        textPaint.setTextSize(this.expandedTextSize);
        textPaint.setTypeface(this.expandedTypeface);
    }

    private void getTextPaintExpanded2(@NonNull TextPaint textPaint) {
        textPaint.setTextSize(this.expandedTextSize2);
        textPaint.setTypeface(this.expandedTypeface2);
    }

    private void getTextPaintCollapsed(@NonNull TextPaint textPaint) {
        textPaint.setTextSize(this.collapsedTextSize);
        textPaint.setTypeface(this.collapsedTypeface);
    }

    private void getTextPaintCollapsed2(@NonNull TextPaint textPaint) {
        textPaint.setTextSize(this.collapsedTextSize2);
        textPaint.setTypeface(this.collapsedTypeface2);
    }

    void onBoundsChanged() {
        this.drawTitle = this.collapsedBounds.width() > 0 && this.collapsedBounds.height() > 0 && this.expandedBounds.width() > 0 && this.expandedBounds.height() > 0;
    }

    public void setExpandedTextGravity(int gravity) {
        if (this.expandedTextGravity != gravity) {
            this.expandedTextGravity = gravity;
            this.recalculate();
        }
    }

    public int getExpandedTextGravity() {
        return this.expandedTextGravity;
    }

    public void setCollapsedTextGravity(int gravity) {
        if (this.collapsedTextGravity != gravity) {
            this.collapsedTextGravity = gravity;
            this.recalculate();
        }
    }

    public int getCollapsedTextGravity() {
        return this.collapsedTextGravity;
    }

    public void setCollapsedTextAppearance(int resId) {
        TextAppearance textAppearance = new TextAppearance(this.view.getContext(), resId);
        if (textAppearance.textColor != null) {
            this.collapsedTextColor = textAppearance.textColor;
        }
        if (textAppearance.textSize != 0.0f) {
            this.collapsedTextSize = textAppearance.textSize;
        }
        if (textAppearance.shadowColor != null) {
            this.collapsedShadowColor = textAppearance.shadowColor;
        }
        this.collapsedShadowDx = textAppearance.shadowDx;
        this.collapsedShadowDy = textAppearance.shadowDy;
        this.collapsedShadowRadius = textAppearance.shadowRadius;
        if (this.collapsedFontCallback != null) {
            this.collapsedFontCallback.cancel();
        }
        this.collapsedFontCallback = new CancelableFontCallback(new CancelableFontCallback.ApplyFont(){

            public void apply(Typeface font) {
                CollapsingTextHelper2.this.setCollapsedTypeface(font);
            }
        }, textAppearance.getFallbackFont());
        textAppearance.getFontAsync(this.view.getContext(), (TextAppearanceFontCallback)this.collapsedFontCallback);
        this.recalculate();
    }

    public void setCollapsedTextAppearance2(int resId) {
        TextAppearance textAppearance = new TextAppearance(this.view.getContext(), resId);
        if (textAppearance.textColor != null) {
            this.collapsedTextColor2 = textAppearance.textColor;
        }
        if (textAppearance.textSize != 0.0f) {
            this.collapsedTextSize2 = textAppearance.textSize;
        }
        if (textAppearance.shadowColor != null) {
            this.collapsedShadowColor2 = textAppearance.shadowColor;
        }
        this.collapsedShadowDx2 = textAppearance.shadowDx;
        this.collapsedShadowDy2 = textAppearance.shadowDy;
        this.collapsedShadowRadius2 = textAppearance.shadowRadius;
        if (this.collapsedFontCallback2 != null) {
            this.collapsedFontCallback2.cancel();
        }
        this.collapsedFontCallback2 = new CancelableFontCallback(new CancelableFontCallback.ApplyFont(){

            public void apply(Typeface font) {
                CollapsingTextHelper2.this.setCollapsedTypeface2(font);
            }
        }, textAppearance.getFallbackFont());
        textAppearance.getFontAsync(this.view.getContext(), (TextAppearanceFontCallback)this.collapsedFontCallback2);
        this.recalculate();
    }

    public void setExpandedTextAppearance(int resId) {
        TextAppearance textAppearance = new TextAppearance(this.view.getContext(), resId);
        if (textAppearance.textColor != null) {
            this.expandedTextColor = textAppearance.textColor;
        }
        if (textAppearance.textSize != 0.0f) {
            this.expandedTextSize = textAppearance.textSize;
        }
        if (textAppearance.shadowColor != null) {
            this.expandedShadowColor = textAppearance.shadowColor;
        }
        this.expandedShadowDx = textAppearance.shadowDx;
        this.expandedShadowDy = textAppearance.shadowDy;
        this.expandedShadowRadius = textAppearance.shadowRadius;
        if (this.expandedFontCallback != null) {
            this.expandedFontCallback.cancel();
        }
        this.expandedFontCallback = new CancelableFontCallback(new CancelableFontCallback.ApplyFont(){

            public void apply(Typeface font) {
                CollapsingTextHelper2.this.setExpandedTypeface(font);
            }
        }, textAppearance.getFallbackFont());
        textAppearance.getFontAsync(this.view.getContext(), (TextAppearanceFontCallback)this.expandedFontCallback);
        this.recalculate();
    }

    public void setExpandedTextAppearance2(int resId) {
        TextAppearance textAppearance = new TextAppearance(this.view.getContext(), resId);
        if (textAppearance.textColor != null) {
            this.expandedTextColor2 = textAppearance.textColor;
        }
        if (textAppearance.textSize != 0.0f) {
            this.expandedTextSize2 = textAppearance.textSize;
        }
        if (textAppearance.shadowColor != null) {
            this.expandedShadowColor2 = textAppearance.shadowColor;
        }
        this.expandedShadowDx2 = textAppearance.shadowDx;
        this.expandedShadowDy2 = textAppearance.shadowDy;
        this.expandedShadowRadius2 = textAppearance.shadowRadius;
        if (this.expandedFontCallback2 != null) {
            this.expandedFontCallback2.cancel();
        }
        this.expandedFontCallback2 = new CancelableFontCallback(new CancelableFontCallback.ApplyFont(){

            public void apply(Typeface font) {
                CollapsingTextHelper2.this.setExpandedTypeface2(font);
            }
        }, textAppearance.getFallbackFont());
        textAppearance.getFontAsync(this.view.getContext(), (TextAppearanceFontCallback)this.expandedFontCallback2);
        this.recalculate();
    }

    public void setCollapsedTypeface(Typeface typeface) {
        if (this.setCollapsedTypefaceInternal(typeface)) {
            this.recalculate();
        }
    }

    public void setCollapsedTypeface2(Typeface typeface) {
        if (this.setCollapsedTypefaceInternal2(typeface)) {
            this.recalculate();
        }
    }

    public void setExpandedTypeface(Typeface typeface) {
        if (this.setExpandedTypefaceInternal(typeface)) {
            this.recalculate();
        }
    }

    public void setExpandedTypeface2(Typeface typeface) {
        if (this.setExpandedTypefaceInternal2(typeface)) {
            this.recalculate();
        }
    }

    public void setTypefaces(Typeface typeface) {
        boolean collapsedFontChanged = this.setCollapsedTypefaceInternal(typeface);
        boolean expandedFontChanged = this.setExpandedTypefaceInternal(typeface);
        if (collapsedFontChanged || expandedFontChanged) {
            this.recalculate();
        }
    }

    public void setTypefaces2(Typeface typeface) {
        boolean collapsedFontChanged = this.setCollapsedTypefaceInternal2(typeface);
        boolean expandedFontChanged = this.setExpandedTypefaceInternal2(typeface);
        if (collapsedFontChanged || expandedFontChanged) {
            this.recalculate();
        }
    }

    private boolean setCollapsedTypefaceInternal(Typeface typeface) {
        if (this.collapsedFontCallback != null) {
            this.collapsedFontCallback.cancel();
        }
        if (this.collapsedTypeface != typeface) {
            this.collapsedTypeface = typeface;
            return true;
        }
        return false;
    }

    private boolean setCollapsedTypefaceInternal2(Typeface typeface) {
        if (this.collapsedFontCallback2 != null) {
            this.collapsedFontCallback2.cancel();
        }
        if (this.collapsedTypeface2 != typeface) {
            this.collapsedTypeface2 = typeface;
            return true;
        }
        return false;
    }

    private boolean setExpandedTypefaceInternal(Typeface typeface) {
        if (this.expandedFontCallback != null) {
            this.expandedFontCallback.cancel();
        }
        if (this.expandedTypeface != typeface) {
            this.expandedTypeface = typeface;
            return true;
        }
        return false;
    }

    private boolean setExpandedTypefaceInternal2(Typeface typeface) {
        if (this.expandedFontCallback2 != null) {
            this.expandedFontCallback2.cancel();
        }
        if (this.expandedTypeface2 != typeface) {
            this.expandedTypeface2 = typeface;
            return true;
        }
        return false;
    }

    public Typeface getCollapsedTypeface() {
        return this.collapsedTypeface != null ? this.collapsedTypeface : Typeface.DEFAULT;
    }

    public Typeface getCollapsedTypeface2() {
        return this.collapsedTypeface2 != null ? this.collapsedTypeface2 : Typeface.DEFAULT;
    }

    public Typeface getExpandedTypeface() {
        return this.expandedTypeface != null ? this.expandedTypeface : Typeface.DEFAULT;
    }

    public Typeface getExpandedTypeface2() {
        return this.expandedTypeface2 != null ? this.expandedTypeface2 : Typeface.DEFAULT;
    }

    public void setExpansionFraction(float fraction) {
        if ((fraction = MathUtils.clamp((float)fraction, (float)0.0f, (float)1.0f)) != this.expandedFraction) {
            this.expandedFraction = fraction;
            this.calculateCurrentOffsets();
        }
    }

    public final boolean setState(int[] state) {
        this.state = state;
        if (this.isStateful()) {
            this.recalculate();
            return true;
        }
        return false;
    }

    public final boolean isStateful() {
        return this.collapsedTextColor != null && this.collapsedTextColor.isStateful() || this.collapsedTextColor2 != null && this.collapsedTextColor2.isStateful() || this.expandedTextColor != null && this.expandedTextColor.isStateful() || this.expandedTextColor2 != null && this.expandedTextColor2.isStateful();
    }

    public float getExpansionFraction() {
        return this.expandedFraction;
    }

    public float getCollapsedTextSize() {
        return this.collapsedTextSize;
    }

    public float getCollapsedTextSize2() {
        return this.collapsedTextSize2;
    }

    public float getExpandedTextSize() {
        return this.expandedTextSize;
    }

    public float getExpandedTextSize2() {
        return this.expandedTextSize2;
    }

    private void calculateCurrentOffsets() {
        this.calculateOffsets(this.expandedFraction);
    }

    private void calculateOffsets(float fraction) {
        this.interpolateBounds(fraction);
        this.currentDrawX = CollapsingTextHelper2.lerp(this.expandedDrawX, this.collapsedDrawX, fraction, this.positionInterpolator);
        this.currentDrawX2 = CollapsingTextHelper2.lerp(this.expandedDrawX2, this.collapsedDrawX2, fraction, this.positionInterpolator);
        this.currentDrawY = CollapsingTextHelper2.lerp(this.expandedDrawY, this.collapsedDrawY, fraction, this.positionInterpolator);
        this.currentDrawY2 = CollapsingTextHelper2.lerp(this.expandedDrawY2, this.collapsedDrawY2, fraction, this.positionInterpolator);
        this.setInterpolatedTextSize(CollapsingTextHelper2.lerp(this.expandedTextSize, this.collapsedTextSize, fraction, this.textSizeInterpolator));
        this.setInterpolatedTextSize2(CollapsingTextHelper2.lerp(this.expandedTextSize2, this.collapsedTextSize2, fraction, this.textSizeInterpolator));
        if (this.collapsedTextColor != this.expandedTextColor) {
            this.textPaint.setColor(CollapsingTextHelper2.blendColors(this.getCurrentExpandedTextColor(), this.getCurrentCollapsedTextColor(), fraction));
        } else {
            this.textPaint.setColor(this.getCurrentCollapsedTextColor());
        }
        if (this.collapsedTextColor2 != this.expandedTextColor2) {
            this.textPaint2.setColor(CollapsingTextHelper2.blendColors(this.getCurrentExpandedTextColor2(), this.getCurrentCollapsedTextColor2(), fraction));
        } else {
            this.textPaint2.setColor(this.getCurrentCollapsedTextColor2());
        }
        this.textPaint.setShadowLayer(CollapsingTextHelper2.lerp(this.expandedShadowRadius, this.collapsedShadowRadius, fraction, null), CollapsingTextHelper2.lerp(this.expandedShadowDx, this.collapsedShadowDx, fraction, null), CollapsingTextHelper2.lerp(this.expandedShadowDy, this.collapsedShadowDy, fraction, null), CollapsingTextHelper2.blendColors(this.getCurrentColor(this.expandedShadowColor), this.getCurrentColor(this.collapsedShadowColor), fraction));
        this.textPaint2.setShadowLayer(CollapsingTextHelper2.lerp(this.expandedShadowRadius2, this.collapsedShadowRadius2, fraction, null), CollapsingTextHelper2.lerp(this.expandedShadowDx2, this.collapsedShadowDx2, fraction, null), CollapsingTextHelper2.lerp(this.expandedShadowDy2, this.collapsedShadowDy2, fraction, null), CollapsingTextHelper2.blendColors(this.getCurrentColor(this.expandedShadowColor2), this.getCurrentColor(this.collapsedShadowColor2), fraction));
        ViewCompat.postInvalidateOnAnimation((View)this.view);
    }

    @ColorInt
    private int getCurrentExpandedTextColor() {
        return this.getCurrentColor(this.expandedTextColor);
    }

    @ColorInt
    private int getCurrentExpandedTextColor2() {
        return this.getCurrentColor(this.expandedTextColor2);
    }

    @ColorInt
    public int getCurrentCollapsedTextColor() {
        return this.getCurrentColor(this.collapsedTextColor);
    }

    @ColorInt
    public int getCurrentCollapsedTextColor2() {
        return this.getCurrentColor(this.collapsedTextColor2);
    }

    @ColorInt
    private int getCurrentColor(@Nullable ColorStateList colorStateList) {
        if (colorStateList == null) {
            return 0;
        }
        if (this.state != null) {
            return colorStateList.getColorForState(this.state, 0);
        }
        return colorStateList.getDefaultColor();
    }

    private void calculateBaseOffsets() {
        float currentTextSize = this.currentTextSize;
        float currentTextSize2 = this.currentTextSize2;
        boolean isTitleOnly = TextUtils.isEmpty((CharSequence)this.text2);
        this.calculateUsingTextSize(this.collapsedTextSize);
        this.calculateUsingTextSize2(this.collapsedTextSize2);
        float width = this.textToDraw != null ? this.textPaint.measureText(this.textToDraw, 0, this.textToDraw.length()) : 0.0f;
        float width2 = this.textToDraw2 != null ? this.textPaint2.measureText(this.textToDraw2, 0, this.textToDraw2.length()) : 0.0f;
        int collapsedAbsGravity = GravityCompat.getAbsoluteGravity((int)this.collapsedTextGravity, (int)(this.isRtl ? 1 : 0));
        float textHeight = this.textPaint.descent() - this.textPaint.ascent();
        float textHeight2 = this.textPaint2.descent() - this.textPaint2.ascent();
        float textOffset = textHeight / 2.0f - this.textPaint.descent();
        float textOffset2 = textHeight2 / 2.0f - this.textPaint2.descent();
        if (isTitleOnly) {
            switch (collapsedAbsGravity & 0x70) {
                case 80: {
                    this.collapsedDrawY = this.collapsedBounds.bottom;
                    break;
                }
                case 48: {
                    this.collapsedDrawY = (float)this.collapsedBounds.top - this.textPaint.ascent();
                    break;
                }
                default: {
                    this.collapsedDrawY = (float)this.collapsedBounds.centerY() + textOffset;
                    break;
                }
            }
        } else {
            switch (collapsedAbsGravity & 0x70) {
                case 80: {
                    this.collapsedDrawY = (float)this.collapsedBounds.bottom - textHeight2 - textOffset;
                    this.collapsedDrawY2 = this.collapsedBounds.bottom;
                    break;
                }
                case 48: {
                    this.collapsedDrawY = (float)this.collapsedBounds.top - this.textPaint.ascent();
                    this.collapsedDrawY2 = this.collapsedDrawY + textHeight2 + textOffset;
                    break;
                }
                default: {
                    this.collapsedDrawY = (float)this.collapsedBounds.centerY() - textOffset2 / 2.0f;
                    this.collapsedDrawY2 = this.collapsedDrawY + textHeight2;
                }
            }
        }
        switch (collapsedAbsGravity & 0x800007) {
            case 1: {
                this.collapsedDrawX = (float)this.collapsedBounds.centerX() - width / 2.0f;
                this.collapsedDrawX2 = (float)this.collapsedBounds.centerX() - width2 / 2.0f;
                break;
            }
            case 5: {
                this.collapsedDrawX = (float)this.collapsedBounds.right - width;
                this.collapsedDrawX2 = (float)this.collapsedBounds.right - width2;
                break;
            }
            default: {
                this.collapsedDrawX = this.collapsedBounds.left;
                this.collapsedDrawX2 = this.collapsedBounds.left;
            }
        }
        this.calculateUsingTextSize(this.expandedTextSize);
        this.calculateUsingTextSize2(this.expandedTextSize2);
        width = this.textToDraw != null ? this.textPaint.measureText(this.textToDraw, 0, this.textToDraw.length()) : 0.0f;
        width2 = this.textToDraw2 != null ? this.textPaint2.measureText(this.textToDraw2, 0, this.textToDraw2.length()) : 0.0f;
        int expandedAbsGravity = GravityCompat.getAbsoluteGravity((int)this.expandedTextGravity, (int)(this.isRtl ? 1 : 0));
        textHeight = this.textPaint.descent() - this.textPaint.ascent();
        textHeight2 = this.textPaint2.descent() - this.textPaint2.ascent();
        textOffset = textHeight / 2.0f - this.textPaint.descent();
        textOffset2 = textHeight2 / 2.0f - this.textPaint2.descent();
        if (isTitleOnly) {
            switch (expandedAbsGravity & 0x70) {
                case 80: {
                    this.expandedDrawY = this.expandedBounds.bottom;
                    break;
                }
                case 48: {
                    this.expandedDrawY = (float)this.expandedBounds.top - this.textPaint.ascent();
                    break;
                }
                default: {
                    this.expandedDrawY = (float)this.expandedBounds.centerY() + textOffset;
                    break;
                }
            }
        } else {
            switch (expandedAbsGravity & 0x70) {
                case 80: {
                    this.expandedDrawY = (float)this.expandedBounds.bottom - textHeight2 - textOffset;
                    this.expandedDrawY2 = this.expandedBounds.bottom;
                    break;
                }
                case 48: {
                    this.expandedDrawY = (float)this.expandedBounds.top - this.textPaint.ascent();
                    this.expandedDrawY2 = this.expandedDrawY + textHeight2 + textOffset;
                    break;
                }
                default: {
                    this.expandedDrawY = this.expandedBounds.centerY();
                    this.expandedDrawY2 = this.expandedDrawY + textHeight2 + textOffset;
                }
            }
        }
        switch (expandedAbsGravity & 0x800007) {
            case 1: {
                this.expandedDrawX = (float)this.expandedBounds.centerX() - width / 2.0f;
                this.expandedDrawX2 = (float)this.expandedBounds.centerX() - width2 / 2.0f;
                break;
            }
            case 5: {
                this.expandedDrawX = (float)this.expandedBounds.right - width;
                this.expandedDrawX2 = (float)this.expandedBounds.right - width2;
                break;
            }
            default: {
                this.expandedDrawX = this.expandedBounds.left;
                this.expandedDrawX2 = this.expandedBounds.left;
            }
        }
        this.clearTexture();
        this.setInterpolatedTextSize(currentTextSize);
        this.setInterpolatedTextSize2(currentTextSize2);
    }

    private void interpolateBounds(float fraction) {
        this.currentBounds.left = CollapsingTextHelper2.lerp(this.expandedBounds.left, this.collapsedBounds.left, fraction, this.positionInterpolator);
        this.currentBounds.top = CollapsingTextHelper2.lerp(this.expandedDrawY, this.collapsedDrawY, fraction, this.positionInterpolator);
        this.currentBounds.right = CollapsingTextHelper2.lerp(this.expandedBounds.right, this.collapsedBounds.right, fraction, this.positionInterpolator);
        this.currentBounds.bottom = CollapsingTextHelper2.lerp(this.expandedBounds.bottom, this.collapsedBounds.bottom, fraction, this.positionInterpolator);
    }

    public void draw(@NonNull Canvas canvas) {
        int saveCount = canvas.save();
        if (this.drawTitle && this.textToDraw != null) {
            float ascent;
            boolean drawTexture;
            float x = this.currentDrawX;
            float y = this.currentDrawY;
            boolean bl = drawTexture = this.useTexture && this.expandedTitleTexture != null;
            if (drawTexture) {
                ascent = this.textureAscent * this.scale;
                float descent = this.textureDescent * this.scale;
            } else {
                ascent = this.textPaint.ascent() * this.scale;
                float descent = this.textPaint.descent() * this.scale;
            }
            if (drawTexture) {
                y += ascent;
            }
            if (this.textToDraw2 != null) {
                float ascent2;
                boolean drawTexture2;
                int saveCount2 = canvas.save();
                float x2 = this.currentDrawX2;
                float y2 = this.currentDrawY2;
                boolean bl2 = drawTexture2 = this.useTexture && this.expandedTitleTexture2 != null;
                if (drawTexture2) {
                    ascent2 = this.textureAscent2 * this.scale2;
                    float descent2 = this.textureDescent2 * this.scale2;
                } else {
                    ascent2 = this.textPaint2.ascent() * this.scale2;
                    float descent2 = this.textPaint2.descent() * this.scale2;
                }
                if (drawTexture2) {
                    y2 += ascent2;
                }
                if (this.scale2 != 1.0f) {
                    canvas.scale(this.scale2, this.scale2, x2, y2);
                }
                if (drawTexture2) {
                    canvas.drawBitmap(this.expandedTitleTexture2, x2, y2, this.texturePaint2);
                } else {
                    canvas.drawText(this.textToDraw2, 0, this.textToDraw2.length(), x2, y2, (Paint)this.textPaint2);
                }
                canvas.restoreToCount(saveCount2);
            }
            if (this.scale != 1.0f) {
                canvas.scale(this.scale, this.scale, x, y);
            }
            if (drawTexture) {
                canvas.drawBitmap(this.expandedTitleTexture, x, y, this.texturePaint);
            } else {
                canvas.drawText(this.textToDraw, 0, this.textToDraw.length(), x, y, (Paint)this.textPaint);
            }
        }
        canvas.restoreToCount(saveCount);
    }

    private boolean calculateIsRtl(@NonNull CharSequence text) {
        boolean defaultIsRtl = ViewCompat.getLayoutDirection((View)this.view) == 1;
        return (defaultIsRtl ? TextDirectionHeuristicsCompat.FIRSTSTRONG_RTL : TextDirectionHeuristicsCompat.FIRSTSTRONG_LTR).isRtl(text, 0, text.length());
    }

    private void setInterpolatedTextSize(float textSize) {
        this.calculateUsingTextSize(textSize);
        boolean bl = this.useTexture = USE_SCALING_TEXTURE && this.scale != 1.0f;
        if (this.useTexture) {
            this.ensureExpandedTexture();
        }
        ViewCompat.postInvalidateOnAnimation((View)this.view);
    }

    private void setInterpolatedTextSize2(float textSize) {
        this.calculateUsingTextSize2(textSize);
        boolean bl = this.useTexture = USE_SCALING_TEXTURE && this.scale2 != 1.0f;
        if (this.useTexture) {
            this.ensureExpandedTexture2();
        }
        ViewCompat.postInvalidateOnAnimation((View)this.view);
    }

    private void calculateUsingTextSize(float size) {
        float availableWidth;
        float newTextSize;
        if (this.text == null) {
            return;
        }
        float collapsedWidth = this.collapsedBounds.width();
        float expandedWidth = this.expandedBounds.width();
        boolean updateDrawText = false;
        if (CollapsingTextHelper2.isClose(size, this.collapsedTextSize)) {
            newTextSize = this.collapsedTextSize;
            this.scale = 1.0f;
            if (this.currentTypeface != this.collapsedTypeface) {
                this.currentTypeface = this.collapsedTypeface;
                updateDrawText = true;
            }
            availableWidth = collapsedWidth;
        } else {
            newTextSize = this.expandedTextSize;
            if (this.currentTypeface != this.expandedTypeface) {
                this.currentTypeface = this.expandedTypeface;
                updateDrawText = true;
            }
            this.scale = CollapsingTextHelper2.isClose(size, this.expandedTextSize) ? 1.0f : size / this.expandedTextSize;
            float textSizeRatio = this.collapsedTextSize / this.expandedTextSize;
            float scaledDownWidth = expandedWidth * textSizeRatio;
            availableWidth = scaledDownWidth > collapsedWidth ? Math.min(collapsedWidth / textSizeRatio, expandedWidth) : expandedWidth;
        }
        if (availableWidth > 0.0f) {
            updateDrawText = this.currentTextSize != newTextSize || this.boundsChanged || updateDrawText;
            this.currentTextSize = newTextSize;
            this.boundsChanged = false;
        }
        if (this.textToDraw == null || updateDrawText) {
            this.textPaint.setTextSize(this.currentTextSize);
            this.textPaint.setTypeface(this.currentTypeface);
            this.textPaint.setLinearText(this.scale != 1.0f);
            CharSequence text = TextUtils.ellipsize((CharSequence)this.text, (TextPaint)this.textPaint, (float)availableWidth, (TextUtils.TruncateAt)TextUtils.TruncateAt.END);
            if (!TextUtils.equals((CharSequence)text, (CharSequence)this.textToDraw)) {
                this.textToDraw = text;
                this.isRtl = this.calculateIsRtl(this.textToDraw);
            }
        }
    }

    private void calculateUsingTextSize2(float size) {
        float availableWidth;
        float newTextSize;
        if (this.text2 == null) {
            return;
        }
        float collapsedWidth = this.collapsedBounds.width();
        float expandedWidth = this.expandedBounds.width();
        boolean updateDrawText = false;
        if (CollapsingTextHelper2.isClose(size, this.collapsedTextSize2)) {
            newTextSize = this.collapsedTextSize2;
            this.scale2 = 1.0f;
            if (this.currentTypeface2 != this.collapsedTypeface2) {
                this.currentTypeface2 = this.collapsedTypeface2;
                updateDrawText = true;
            }
            availableWidth = collapsedWidth;
        } else {
            newTextSize = this.expandedTextSize2;
            if (this.currentTypeface2 != this.expandedTypeface2) {
                this.currentTypeface2 = this.expandedTypeface2;
                updateDrawText = true;
            }
            this.scale2 = CollapsingTextHelper2.isClose(size, this.expandedTextSize2) ? 1.0f : size / this.expandedTextSize2;
            float textSizeRatio = this.collapsedTextSize2 / this.expandedTextSize2;
            float scaledDownWidth = expandedWidth * textSizeRatio;
            availableWidth = scaledDownWidth > collapsedWidth ? Math.min(collapsedWidth / textSizeRatio, expandedWidth) : expandedWidth;
        }
        if (availableWidth > 0.0f) {
            updateDrawText = this.currentTextSize2 != newTextSize || this.boundsChanged || updateDrawText;
            this.currentTextSize2 = newTextSize;
            this.boundsChanged = false;
        }
        if (this.textToDraw2 == null || updateDrawText) {
            this.textPaint2.setTextSize(this.currentTextSize2);
            this.textPaint2.setTypeface(this.currentTypeface2);
            this.textPaint2.setLinearText(this.scale2 != 1.0f);
            CharSequence text = TextUtils.ellipsize((CharSequence)this.text2, (TextPaint)this.textPaint2, (float)availableWidth, (TextUtils.TruncateAt)TextUtils.TruncateAt.END);
            if (!TextUtils.equals((CharSequence)text, (CharSequence)this.textToDraw2)) {
                this.textToDraw2 = text;
                this.isRtl = this.calculateIsRtl(this.textToDraw2);
            }
        }
    }

    private void ensureExpandedTexture() {
        if (this.expandedTitleTexture != null || this.expandedBounds.isEmpty() || TextUtils.isEmpty((CharSequence)this.textToDraw)) {
            return;
        }
        this.calculateOffsets(0.0f);
        this.textureAscent = this.textPaint.ascent();
        this.textureDescent = this.textPaint.descent();
        int w = Math.round(this.textPaint.measureText(this.textToDraw, 0, this.textToDraw.length()));
        int h = Math.round(this.textureDescent - this.textureAscent);
        if (w <= 0 || h <= 0) {
            return;
        }
        this.expandedTitleTexture = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas c = new Canvas(this.expandedTitleTexture);
        c.drawText(this.textToDraw, 0, this.textToDraw.length(), 0.0f, (float)h - this.textPaint.descent(), (Paint)this.textPaint);
        if (this.texturePaint == null) {
            this.texturePaint = new Paint(3);
        }
    }

    private void ensureExpandedTexture2() {
        if (this.expandedTitleTexture2 != null || this.expandedBounds.isEmpty() || TextUtils.isEmpty((CharSequence)this.textToDraw2)) {
            return;
        }
        this.calculateOffsets(0.0f);
        this.textureAscent2 = this.textPaint2.ascent();
        this.textureDescent2 = this.textPaint2.descent();
        int w = Math.round(this.textPaint2.measureText(this.textToDraw2, 0, this.textToDraw2.length()));
        int h = Math.round(this.textureDescent2 - this.textureAscent2);
        if (w <= 0 || h <= 0) {
            return;
        }
        this.expandedTitleTexture2 = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas c = new Canvas(this.expandedTitleTexture2);
        c.drawText(this.textToDraw2, 0, this.textToDraw2.length(), 0.0f, (float)h - this.textPaint2.descent(), (Paint)this.textPaint2);
        if (this.texturePaint2 == null) {
            this.texturePaint2 = new Paint(3);
        }
    }

    public void recalculate() {
        if (this.view.getHeight() > 0 && this.view.getWidth() > 0) {
            this.calculateBaseOffsets();
            this.calculateCurrentOffsets();
        }
    }

    public void setText(@Nullable CharSequence text) {
        if (text == null || !text.equals(this.text)) {
            this.text = text;
            this.textToDraw = null;
            this.clearTexture();
            this.recalculate();
        }
    }

    public void setText2(@Nullable CharSequence text) {
        if (text == null || !text.equals(this.text2)) {
            this.text2 = text;
            this.textToDraw2 = null;
            this.clearTexture();
            this.recalculate();
        }
    }

    @Nullable
    public CharSequence getText() {
        return this.text;
    }

    @Nullable
    public CharSequence getText2() {
        return this.text2;
    }

    private void clearTexture() {
        if (this.expandedTitleTexture != null) {
            this.expandedTitleTexture.recycle();
            this.expandedTitleTexture = null;
        }
        if (this.expandedTitleTexture2 != null) {
            this.expandedTitleTexture2.recycle();
            this.expandedTitleTexture2 = null;
        }
    }

    private static boolean isClose(float value, float targetValue) {
        return Math.abs(value - targetValue) < 0.001f;
    }

    public ColorStateList getExpandedTextColor() {
        return this.expandedTextColor;
    }

    public ColorStateList getExpandedTextColor2() {
        return this.expandedTextColor2;
    }

    public ColorStateList getCollapsedTextColor() {
        return this.collapsedTextColor;
    }

    public ColorStateList getCollapsedTextColor2() {
        return this.collapsedTextColor2;
    }

    private static int blendColors(int color1, int color2, float ratio) {
        float inverseRatio = 1.0f - ratio;
        float a = (float)Color.alpha((int)color1) * inverseRatio + (float)Color.alpha((int)color2) * ratio;
        float r = (float)Color.red((int)color1) * inverseRatio + (float)Color.red((int)color2) * ratio;
        float g = (float)Color.green((int)color1) * inverseRatio + (float)Color.green((int)color2) * ratio;
        float b = (float)Color.blue((int)color1) * inverseRatio + (float)Color.blue((int)color2) * ratio;
        return Color.argb((int)((int)a), (int)((int)r), (int)((int)g), (int)((int)b));
    }

    private static float lerp(float startValue, float endValue, float fraction, @Nullable TimeInterpolator interpolator) {
        if (interpolator != null) {
            fraction = interpolator.getInterpolation(fraction);
        }
        return AnimationUtils.lerp((float)startValue, (float)endValue, (float)fraction);
    }

    private static boolean rectEquals(@NonNull Rect r, int left, int top, int right, int bottom) {
        return r.left == left && r.top == top && r.right == right && r.bottom == bottom;
    }

    static {
        if (DEBUG_DRAW_PAINT != null) {
            DEBUG_DRAW_PAINT.setAntiAlias(true);
            DEBUG_DRAW_PAINT.setColor(-65281);
        }
    }
}

