/*
 * Decompiled with CFR 0.152.
 */
package com.hendraanggrian.compat.view;

import android.content.Context;
import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import android.view.View;
import java.lang.reflect.InvocationTargetException;

public final class Views {
    private Views() {
    }

    public static <T extends View> T newInstance(@NonNull Class<T> cls, @NonNull Context context) {
        try {
            return (T)((View)cls.getConstructor(Context.class).newInstance(context));
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Unable to create an instance of " + cls.getSimpleName() + ": is this view class abstract?");
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to create an instance of " + cls.getSimpleName() + ": is this view class private?");
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Unable to create an instance of " + cls.getSimpleName() + ": unknown error.");
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Unable to create an instance of " + cls.getSimpleName() + ": does this view has Context-only constructor?");
        }
    }

    public static <T extends View> T findViewById(@NonNull View view, @IdRes int id) {
        return (T)view.findViewById(id);
    }

    public static <T extends View> T findViewWithTag(@NonNull View view, @NonNull String tag) {
        return (T)view.findViewWithTag((Object)tag);
    }

    public static boolean setVisibility(@NonNull View view, int visibility) {
        if (visibility == 0 && view.getVisibility() != 0) {
            view.setVisibility(0);
        } else if (visibility == 8 && view.getVisibility() != 8) {
            view.setVisibility(8);
        } else if (visibility == 4 && view.getVisibility() != 4) {
            view.setVisibility(4);
        }
        return visibility == 0;
    }

    public static boolean setVisible(@NonNull View view, boolean visible) {
        return Views.setVisibility(view, visible ? 0 : 8);
    }

    public static void setVisibilities(int visibility, View ... views) {
        for (View view : views) {
            view.setVisibility(visibility);
        }
    }

    public static void setVisibles(boolean visible, View ... views) {
        for (View view : views) {
            view.setVisibility(visible ? 0 : 8);
        }
    }
}

