/*
 * Decompiled with CFR 0.152.
 */
package com.hendraanggrian.compat.text;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import java.text.DecimalFormat;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.WeakHashMap;

public final class DecimalFormats {
    @Nullable
    static Map<String, DecimalFormat> formats;
    @Nullable
    static NavigableMap<Long, String> suffixes;

    private DecimalFormats() {
    }

    @NonNull
    public static String prettyFormat(int value) {
        return DecimalFormats.prettyFormat((long)value);
    }

    @NonNull
    public static String prettyFormat(long value) {
        if (suffixes == null) {
            suffixes = new TreeMap<Long, String>();
            suffixes.put(1000L, "k");
            suffixes.put(1000000L, "M");
            suffixes.put(1000000000L, "G");
            suffixes.put(1000000000000L, "T");
            suffixes.put(1000000000000000L, "P");
            suffixes.put(1000000000000000000L, "E");
        }
        if (value == Long.MIN_VALUE) {
            return DecimalFormats.prettyFormat(-9223372036854775807L);
        }
        if (value < 0L) {
            return "-" + DecimalFormats.prettyFormat(-value);
        }
        if (value < 1000L) {
            return Long.toString(value);
        }
        Map.Entry<Long, String> e = suffixes.floorEntry(value);
        Long divideBy = e.getKey();
        String suffix = e.getValue();
        long truncated = value / (divideBy / 10L);
        boolean hasDecimal = truncated < 100L && (double)truncated / 10.0 != (double)(truncated / 10L);
        return hasDecimal ? (double)truncated / 10.0 + suffix : truncated / 10L + suffix;
    }

    @NonNull
    public static String format(@NonNull String format, double number) {
        return DecimalFormats.get(format).format(number);
    }

    @NonNull
    public static String format(@NonNull String format, long number) {
        return DecimalFormats.get(format).format(number);
    }

    @NonNull
    public static Number parse(@NonNull String format, String source) {
        try {
            if (TextUtils.isEmpty((CharSequence)source)) {
                throw new NullPointerException();
            }
            return DecimalFormats.get(format).parse(source);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    @NonNull
    public static DecimalFormat get(@NonNull String key) {
        DecimalFormat format;
        if (formats == null) {
            formats = new WeakHashMap<String, DecimalFormat>();
        }
        if ((format = formats.get(key)) != null) {
            return format;
        }
        format = new DecimalFormat(key);
        formats.put(key, format);
        return format;
    }
}

