/*
 * Decompiled with CFR 0.152.
 */
package com.hendraanggrian.commons.view;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public final class ViewGroups {
    public static final int MATCH_PARENT = -1;
    public static final int WRAP_CONTENT = -2;

    private ViewGroups() {
    }

    public static <VG extends ViewGroup, V extends View> V addView(@NonNull VG parent, @NonNull Class<V> childCls, int width, int height) {
        return ViewGroups.addView(parent, childCls, null, width, height);
    }

    public static <VG extends ViewGroup, V extends View> V addView(@NonNull VG parent, @NonNull Class<V> childCls, @Nullable Integer index, int width, int height) {
        try {
            Constructor<V> childConstructor = childCls.getConstructor(Context.class);
            View child = (View)childConstructor.newInstance(parent.getContext());
            child.setLayoutParams(new ViewGroup.LayoutParams(width, height));
            if (index != null) {
                parent.addView(child, index.intValue());
            } else {
                parent.addView(child);
            }
            return (V)child;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

