/*
 * Decompiled with CFR 0.152.
 */
package com.hrb.library;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import android.widget.Toast;
import com.hrb.library.MediaService;
import com.hrb.library.R;

public class MiniMusicView
extends FrameLayout {
    private Context mContext;
    private LinearLayout mLayout;
    private ImageButton mIcon;
    private ImageButton mControlBtn;
    private TextView mMusicTitle;
    private SeekBar mProgressBar;
    private boolean mIsAddView;
    private Intent mServiceIntent;
    private Intent mPauseIntent;
    private Intent mResumeIntent;
    private boolean mIsPlay;
    private MusicStateUpdateReceiver mMusicUpdateReceiver;
    private OnMusicStateListener mMusicStateListener;
    private HeadsetPlugReceiver mHeadsetPlugReceiver;
    private int mMusicDuration;

    public MiniMusicView(Context context) {
        this(context, null);
    }

    public MiniMusicView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MiniMusicView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.mIsAddView = false;
        this.mIsPlay = true;
        this.initView();
        this.initAttributeSet(attrs);
    }

    private void initAttributeSet(AttributeSet attrs) {
        Drawable iconDrawable;
        if (attrs == null) {
            return;
        }
        TypedArray arr = this.mContext.obtainStyledAttributes(attrs, R.styleable.MiniMusicView);
        int titleColor = arr.getColor(R.styleable.MiniMusicView_titleColor, Color.parseColor((String)"#000000"));
        this.setTitleColor(titleColor);
        int titleSize = arr.getDimensionPixelOffset(R.styleable.MiniMusicView_titleTextSize, -1);
        if (titleSize != -1) {
            this.setTitleTextSize(titleSize);
        }
        int iconBgColor = arr.getColor(R.styleable.MiniMusicView_musicIconBackgroundColor, Color.parseColor((String)"#e0e0e0"));
        this.setIconBackgroundColor(iconBgColor);
        int backColor = arr.getColor(R.styleable.MiniMusicView_musicBackgroundColor, Color.parseColor((String)"#eeeeee"));
        this.setMusicBackgroundColor(backColor);
        Drawable progressDrawable = arr.getDrawable(R.styleable.MiniMusicView_progressDrawable);
        if (progressDrawable != null) {
            this.setProgressDrawable(progressDrawable);
        }
        if ((iconDrawable = arr.getDrawable(R.styleable.MiniMusicView_musicIcon)) != null) {
            this.setIconDrawable(iconDrawable);
        }
        arr.recycle();
    }

    private void initView() {
        View.inflate((Context)this.mContext, (int)R.layout.layout_mini_music, (ViewGroup)this);
        this.mLayout = (LinearLayout)this.findViewById(R.id.ll_layout);
        this.mIcon = (ImageButton)this.findViewById(R.id.iv_music_icon);
        this.mControlBtn = (ImageButton)this.findViewById(R.id.ib_control_btn);
        this.mMusicTitle = (TextView)this.findViewById(R.id.tv_music_title);
        this.mProgressBar = (SeekBar)this.findViewById(R.id.sb_progress);
        this.mControlBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                MiniMusicView.this.onControlBtnClick(view);
            }
        });
        this.mMusicUpdateReceiver = new MusicStateUpdateReceiver();
        IntentFilter filter = new IntentFilter();
        filter.addAction("com.mini.media.music.state.action");
        this.mContext.registerReceiver((BroadcastReceiver)this.mMusicUpdateReceiver, filter);
        this.registerHeadsetPlugReceiver();
    }

    private void registerHeadsetPlugReceiver() {
        this.mHeadsetPlugReceiver = new HeadsetPlugReceiver();
        IntentFilter intentFilter = new IntentFilter("android.media.AUDIO_BECOMING_NOISY");
        this.mContext.registerReceiver((BroadcastReceiver)this.mHeadsetPlugReceiver, intentFilter);
    }

    private void onControlBtnClick(View view) {
        if (this.mIsPlay) {
            this.pausePlayMusic();
            this.changeControlBtnState(false);
        } else {
            this.resumePlayMusic();
            this.changeControlBtnState(true);
        }
    }

    public void addView(View child) {
        this.removeAllViews();
        super.addView(child);
        this.mIsAddView = true;
    }

    public void changeControlBtnState(boolean isPlay) {
        if (!this.mIsAddView && this.mControlBtn != null) {
            if (isPlay) {
                this.mControlBtn.setImageResource(R.drawable.pause_mini_music);
                this.mIsPlay = true;
            } else {
                this.mControlBtn.setImageResource(R.drawable.play_mini_music);
                this.mIsPlay = false;
            }
        }
    }

    public void setOnMusicStateListener(OnMusicStateListener listener) {
        this.mMusicStateListener = listener;
    }

    public void startPlayMusic(String path) {
        if (this.mServiceIntent == null) {
            this.mServiceIntent = new Intent(this.mContext, MediaService.class);
            this.mServiceIntent.putExtra("option", 0);
            this.mServiceIntent.putExtra("playUrl", path);
            this.mContext.startService(this.mServiceIntent);
        } else {
            Intent playIntent = new Intent();
            playIntent.setAction("com.mini.media.service.action");
            playIntent.putExtra("option", 0);
            playIntent.putExtra("playUrl", path);
            this.mContext.sendBroadcast(playIntent);
        }
    }

    public void resumePlayMusic() {
        if (this.mResumeIntent == null) {
            this.mResumeIntent = new Intent();
            this.mResumeIntent.setAction("com.mini.media.service.action");
            this.mResumeIntent.putExtra("option", 2);
        }
        this.mContext.sendBroadcast(this.mResumeIntent);
    }

    public void pausePlayMusic() {
        if (this.mPauseIntent == null) {
            this.mPauseIntent = new Intent();
            this.mPauseIntent.setAction("com.mini.media.service.action");
            this.mPauseIntent.putExtra("option", 1);
        }
        this.mContext.sendBroadcast(this.mPauseIntent);
    }

    public void seekToMusic(int pos) {
        Intent intent = new Intent();
        intent.setAction("com.mini.media.service.action");
        intent.putExtra("option", 3);
        intent.putExtra("seekPos", pos);
        this.mContext.sendBroadcast(intent);
    }

    public void stopPlayMusic() {
        if (this.mServiceIntent != null) {
            this.mContext.stopService(this.mServiceIntent);
        }
        if (this.mMusicUpdateReceiver != null) {
            this.mContext.unregisterReceiver((BroadcastReceiver)this.mMusicUpdateReceiver);
        }
        if (this.mHeadsetPlugReceiver != null) {
            this.mContext.unregisterReceiver((BroadcastReceiver)this.mHeadsetPlugReceiver);
        }
    }

    public void setTitleColor(int color) {
        if (!this.mIsAddView && this.mMusicTitle != null) {
            this.mMusicTitle.setTextColor(color);
        }
    }

    public void setTitleTextSize(int dimen) {
        if (!this.mIsAddView && this.mMusicTitle != null) {
            this.mMusicTitle.setTextSize(0, (float)dimen);
        }
    }

    public void setIconBackgroundColor(int color) {
        if (!this.mIsAddView && this.mIcon != null) {
            this.mIcon.setBackgroundColor(color);
        }
    }

    public void setMusicBackgroundColor(int color) {
        if (!this.mIsAddView && this.mLayout != null) {
            this.mLayout.setBackgroundColor(color);
        }
    }

    public void setIconDrawable(Drawable background) {
        if (!this.mIsAddView && this.mIcon != null) {
            this.mIcon.setImageDrawable(background);
        }
    }

    public void setProgressDrawable(Drawable drawable2) {
        if (!this.mIsAddView && this.mProgressBar != null) {
            this.mProgressBar.setProgressDrawable(drawable2);
        }
    }

    public void setProgressMax(int max) {
        if (!this.mIsAddView && this.mProgressBar != null) {
            this.mProgressBar.setMax(max);
        }
    }

    public void setTitleText(String text) {
        if (!this.mIsAddView && this.mMusicTitle != null) {
            this.mMusicTitle.setText((CharSequence)text);
        }
    }

    public boolean isPlaying() {
        return this.mIsPlay;
    }

    public int getMusicDuration() {
        return this.mMusicDuration;
    }

    private class HeadsetPlugReceiver
    extends BroadcastReceiver {
        private HeadsetPlugReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.media.AUDIO_BECOMING_NOISY".equals(action) && MiniMusicView.this.mIsPlay) {
                if (MiniMusicView.this.mMusicStateListener != null) {
                    MiniMusicView.this.mMusicStateListener.onHeadsetPullOut();
                }
                if (!MiniMusicView.this.mIsAddView) {
                    MiniMusicView.this.pausePlayMusic();
                    MiniMusicView.this.changeControlBtnState(false);
                }
            }
        }
    }

    public class MusicStateUpdateReceiver
    extends BroadcastReceiver {
        public void onReceive(Context context, Intent intent) {
            int state = intent.getIntExtra("state", -1);
            switch (state) {
                case 4: {
                    if (MiniMusicView.this.mMusicStateListener == null) break;
                    MiniMusicView.this.mMusicStateListener.onMusicPlayComplete();
                    break;
                }
                case 5: {
                    if (MiniMusicView.this.mMusicStateListener != null) {
                        MiniMusicView.this.mMusicStateListener.onError();
                    }
                    if (MiniMusicView.this.mIsAddView) break;
                    Toast.makeText((Context)MiniMusicView.this.mContext, (CharSequence)MiniMusicView.this.getResources().getString(R.string.load_error), (int)0).show();
                    MiniMusicView.this.changeControlBtnState(false);
                    break;
                }
                case 6: {
                    if (MiniMusicView.this.mMusicStateListener == null) break;
                    MiniMusicView.this.mMusicStateListener.onSeekComplete();
                    break;
                }
                case 8: {
                    MiniMusicView.this.mMusicDuration = intent.getIntExtra("duration", -1);
                    if (MiniMusicView.this.mMusicStateListener != null) {
                        MiniMusicView.this.mMusicStateListener.onPrepared(MiniMusicView.this.mMusicDuration);
                    }
                    if (MiniMusicView.this.mIsAddView) break;
                    MiniMusicView.this.setProgressMax(MiniMusicView.this.mMusicDuration);
                    break;
                }
                case 7: {
                    int duration = intent.getIntExtra("duration", 0);
                    int currentPos = intent.getIntExtra("currentPos", 0);
                    if (MiniMusicView.this.mMusicStateListener != null) {
                        MiniMusicView.this.mMusicStateListener.onProgressUpdate(duration, currentPos);
                    }
                    if (MiniMusicView.this.mIsAddView) break;
                    MiniMusicView.this.mProgressBar.setProgress(currentPos);
                    break;
                }
            }
        }
    }

    public static interface OnMusicStateListener {
        public void onPrepared(int var1);

        public void onError();

        public void onMusicPlayComplete();

        public void onSeekComplete();

        public void onProgressUpdate(int var1, int var2);

        public void onHeadsetPullOut();
    }
}

