/*
 * Decompiled with CFR 0.152.
 */
package com.hellosign.sdk.resource.support;

import com.hellosign.sdk.HelloSignException;
import com.hellosign.sdk.resource.AbstractResource;
import com.hellosign.sdk.resource.support.types.SignatureStatus;
import java.util.Date;
import org.json.JSONObject;

public class Signature
extends AbstractResource {
    public static final String SIGNATURE_KEY = "signature";
    public static final String SIGNATURE_ID = "signature_id";
    public static final String SIGNER_EMAIL_ADDRESS = "signer_email_address";
    public static final String SIGNER_NAME = "signer_name";
    public static final String SIGNER_ORDER = "order";
    public static final String SIGNER_STATUS_CODE = "status_code";
    public static final String SIGNER_SIGNED_AT = "signed_at";
    public static final String SIGNER_LAST_VIEWED_AT = "last_viewed_at";
    public static final String SIGNER_LAST_REMINDED_AT = "last_reminded_at";
    public static final String SIGNER_DECLINE_REASON = "decline_reason";

    public Signature() {
    }

    public Signature(JSONObject json) throws HelloSignException {
        super(json, SIGNATURE_KEY);
    }

    public String getId() {
        return this.getString(SIGNATURE_ID);
    }

    public boolean hasId() {
        return this.has(SIGNATURE_ID);
    }

    public String getEmail() {
        return this.getString(SIGNER_EMAIL_ADDRESS);
    }

    public boolean hasEmail() {
        return this.has(SIGNER_EMAIL_ADDRESS);
    }

    public String getName() {
        return this.getString(SIGNER_NAME);
    }

    public boolean hasName() {
        return this.has(SIGNER_NAME);
    }

    public Integer getOrder() {
        return this.getInteger(SIGNER_ORDER);
    }

    public SignatureStatus getStatus() {
        return SignatureStatus.valueOf(this.getString(SIGNER_STATUS_CODE));
    }

    public String getStatusString() {
        return this.getStatus().toString();
    }

    public Date getDateSigned() {
        return this.getDate(SIGNER_SIGNED_AT);
    }

    public Date getLastViewed() {
        return this.getDate(SIGNER_LAST_VIEWED_AT);
    }

    public Date getLastReminded() {
        return this.getDate(SIGNER_LAST_REMINDED_AT);
    }

    public String getDeclineReason() {
        if (this.has(SIGNER_DECLINE_REASON)) {
            return this.getString(SIGNER_DECLINE_REASON);
        }
        return null;
    }
}

