/*
 * Decompiled with CFR 0.152.
 */
package com.heliorm.sql.mysql;

import com.heliorm.Table;
import com.heliorm.def.Field;
import com.heliorm.sql.OrmSqlException;
import com.heliorm.sql.TableGenerator;
import java.util.Optional;
import java.util.StringJoiner;

public class MysqlDialectGenerator
implements TableGenerator {
    public String generateSchema(Table<?> table) throws OrmSqlException {
        StringBuilder sql = new StringBuilder();
        sql.append(String.format("CREATE TABLE %s (\n", this.fullTableName(table)));
        boolean first = true;
        for (Field field : table.getFields()) {
            if (first) {
                first = false;
            } else {
                sql.append(",\n");
            }
            sql.append(String.format("\t`%s` ", field.getSqlName()));
            sql.append(this.generateFieldSql(table, field));
            if (!field.isNullable()) {
                sql.append(" NOT NULL");
            }
            if (!field.isPrimaryKey() || !field.isAutoNumber() || field.getFieldType() == Field.FieldType.STRING) continue;
            sql.append(" AUTO_INCREMENT");
        }
        Optional key = table.getPrimaryKey();
        if (key.isPresent()) {
            sql.append(",\n");
            sql.append(String.format("PRIMARY KEY (`%s`)", ((Field)key.get()).getSqlName()));
        }
        sql.append(");\n");
        return sql.toString();
    }

    private String generateFieldSql(Table table, Field field) throws OrmSqlException {
        switch (field.getFieldType()) {
            case BOOLEAN: {
                return "TINYINT(1)";
            }
            case BYTE: {
                return "TINYINT";
            }
            case SHORT: {
                return "SMALLINT";
            }
            case INTEGER: {
                return "INTEGER";
            }
            case LONG: {
                return "BIGINT";
            }
            case DOUBLE: {
                return "DOUBLE";
            }
            case FLOAT: {
                return "REAL";
            }
            case ENUM: {
                return String.format("ENUM(%s)", this.getEnumValues(table, field));
            }
            case STRING: {
                int length = 255;
                if (field.isPrimaryKey()) {
                    length = 36;
                }
                if (field.getLength().isPresent()) {
                    length = (Integer)field.getLength().get();
                }
                return String.format("VARCHAR(%d)", length);
            }
            case DATE: {
                return "DATE";
            }
            case TIMESTAMP: {
                return "DATETIME";
            }
            case DURATION: {
                return "VARCHAR(32)";
            }
        }
        throw new OrmSqlException(String.format("Unkown field type '%s'. BUG!", field.getFieldType()));
    }

    private String getEnumValues(Table table, Field<?, ?, ?> field) {
        StringJoiner sql = new StringJoiner(",");
        Class javaType = field.getJavaType();
        for (Object v : javaType.getEnumConstants()) {
            sql.add(String.format("'%s'", ((Enum)v).name()));
        }
        return sql.toString();
    }

    private String fullTableName(Table table) {
        return String.format("`%s`.`%s`", table.getDatabase().getSqlDatabase(), table.getSqlTable());
    }
}

