/*
 * Decompiled with CFR 0.152.
 */
package com.heliorm.driver.mysql;

import com.heliorm.Database;
import com.heliorm.OrmException;
import com.heliorm.PojoOperations;
import com.heliorm.Table;
import com.heliorm.def.Field;
import com.heliorm.driver.OrmSqlException;
import com.heliorm.driver.SqlDriver;
import com.heliorm.driver.TableGenerator;
import com.heliorm.driver.mysql.MysqlDialectGenerator;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.function.Supplier;

public final class MySqlDriver
extends SqlDriver {
    public MySqlDriver(Supplier<Connection> connectionSupplier, PojoOperations pops) {
        super(connectionSupplier, pops);
    }

    public MySqlDriver(Supplier<Connection> connectionSupplier, PojoOperations pops, Map<Database, Database> aliases) {
        super(connectionSupplier, pops, aliases);
    }

    protected String fullTableName(Table table) throws OrmException {
        return String.format("%s.%s", this.databaseName(table), this.tableName(table));
    }

    protected String fullFieldName(Table table, Field field) throws OrmException {
        return String.format("%s.`%s`", this.fullTableName(table), field.getSqlName());
    }

    protected String fieldName(Table table, Field field) throws OrmException {
        return String.format("`%s`", field.getSqlName());
    }

    protected String virtualFieldName(String name) {
        return String.format("`%s`", name);
    }

    protected String virtualValue(String name) {
        return String.format("'%s'", name);
    }

    protected TableGenerator getTableGenerator() throws OrmException {
        return new MysqlDialectGenerator();
    }

    protected Object getKeyValueFromResultSet(ResultSet rs, Field field) throws OrmException {
        try {
            int idx = 1;
            switch (field.getFieldType()) {
                case LONG: {
                    return rs.getLong(idx);
                }
                case INTEGER: {
                    return rs.getInt(idx);
                }
                case STRING: {
                    return rs.getString(idx);
                }
                case SHORT: 
                case BYTE: 
                case DOUBLE: 
                case FLOAT: 
                case BOOLEAN: 
                case ENUM: 
                case DATE: 
                case TIMESTAMP: 
                case DURATION: {
                    throw new OrmException(String.format("Field type '%s' is not a supported primary key type", field.getFieldType()));
                }
            }
            throw new OrmException(String.format("Field type '%s' is unsupported. BUG!", field.getFieldType()));
        }
        catch (SQLException ex) {
            throw new OrmSqlException(ex.getMessage(), (Throwable)ex);
        }
    }

    protected boolean useUnionAll() {
        return true;
    }
}

