/*
 * Decompiled with CFR 0.152.
 */
package com.helian.app.statistics.util;

import android.content.Context;
import android.content.SharedPreferences;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.webkit.WebSettings;
import android.webkit.WebView;
import com.helian.app.deviceid.DeviceIdManager;
import com.helian.app.deviceid.ImeiUtil;
import com.helian.app.deviceid.ImsiUtil;
import com.helian.app.statistics.init.HlDataStatisticInitializer;
import com.helian.app.statistics.manager.AliStatisticManager;
import com.helian.app.statistics.util.DeviceInfoUtil;
import com.helian.app.statistics.util.ua.UserAgent;
import com.helian.app.statistics.util.ua.UserAgentParser;
import java.util.HashMap;
import java.util.Map;

public class HlDataStatisticCommonParamsUtil {
    private static Context sApplication;
    private static SharedPreferences mSp;
    private static String sStationId;
    private static String sSn;
    private static String sDeviceId;

    public static Map<String, String> getParamsMap() {
        sApplication = HlDataStatisticInitializer.getApplication();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("mac", HlDataStatisticCommonParamsUtil.getMac());
        map.put("station_id", HlDataStatisticCommonParamsUtil.getStationId());
        map.put("sn", HlDataStatisticCommonParamsUtil.getSn());
        map.put("ap_mac", HlDataStatisticCommonParamsUtil.getApMac());
        map.put("screen_width", HlDataStatisticCommonParamsUtil.getScreenWidth());
        map.put("screen_height", HlDataStatisticCommonParamsUtil.getScreenHeight());
        map.put("browser", HlDataStatisticCommonParamsUtil.getBrowser());
        map.put("ua", HlDataStatisticCommonParamsUtil.getUa());
        map.put("browser_version", HlDataStatisticCommonParamsUtil.getBrowserVersion());
        map.put("lib", HlDataStatisticCommonParamsUtil.getLib());
        map.put("lib_version", HlDataStatisticCommonParamsUtil.getLibVersion());
        map.put("imei", HlDataStatisticCommonParamsUtil.getIMEI());
        map.put("imsi", HlDataStatisticCommonParamsUtil.getIMSI());
        String lastDeviceId = null;
        if (!TextUtils.isEmpty((CharSequence)sDeviceId)) {
            lastDeviceId = sDeviceId;
        }
        sDeviceId = HlDataStatisticCommonParamsUtil.getDeviceId();
        map.put("device_id", sDeviceId);
        if (!TextUtils.isEmpty((CharSequence)lastDeviceId) && !lastDeviceId.equals(sDeviceId)) {
            map.put("old_device_id", lastDeviceId);
            AliStatisticManager.onEvent("technique_device_idmapping", map);
        }
        return map;
    }

    private static String getDeviceId() {
        return DeviceIdManager.getInstance().getDeviceId();
    }

    private static String getMac() {
        return DeviceInfoUtil.getMac(sApplication);
    }

    private static String getStationId() {
        return sStationId;
    }

    public static void updateStationId(String stationId) {
        sStationId = stationId;
    }

    private static String getSn() {
        return sSn;
    }

    public static void updateSn(String sn) {
        sSn = sn;
    }

    private static String getApMac() {
        if (ContextCompat.checkSelfPermission((Context)sApplication, (String)"android.permission.ACCESS_FINE_LOCATION") != 0) {
            return null;
        }
        WifiManager systemService = (WifiManager)sApplication.getSystemService("wifi");
        WifiInfo connectionInfo = systemService.getConnectionInfo();
        if (connectionInfo != null) {
            return connectionInfo.getBSSID();
        }
        return "";
    }

    private static String getScreenWidth() {
        String s = HlDataStatisticCommonParamsUtil.getSpValue("screen_width");
        if (!TextUtils.isEmpty((CharSequence)s)) {
            return s;
        }
        String s1 = String.valueOf(DeviceInfoUtil.getScreenWith(sApplication));
        HlDataStatisticCommonParamsUtil.setSpValue("screen_width", s1);
        return s1;
    }

    private static String getScreenHeight() {
        String s = HlDataStatisticCommonParamsUtil.getSpValue("screen_height");
        if (!TextUtils.isEmpty((CharSequence)s)) {
            return s;
        }
        String s1 = String.valueOf(DeviceInfoUtil.getScreenHeight(sApplication));
        HlDataStatisticCommonParamsUtil.setSpValue("screen_height", s1);
        return s1;
    }

    private static String getBrowser() {
        String s = HlDataStatisticCommonParamsUtil.getSpValue("browser");
        if (!TextUtils.isEmpty((CharSequence)s)) {
            return s;
        }
        String userAgentString = HlDataStatisticCommonParamsUtil.getUa();
        String browser = new UserAgentParser().browser(userAgentString);
        HlDataStatisticCommonParamsUtil.setSpValue("browser", browser);
        return browser;
    }

    private static String getUa() {
        String s = HlDataStatisticCommonParamsUtil.getSpValue("ua");
        if (!TextUtils.isEmpty((CharSequence)s)) {
            return s;
        }
        WebSettings settings = new WebView(sApplication).getSettings();
        String userAgentString = settings.getUserAgentString();
        HlDataStatisticCommonParamsUtil.setSpValue("ua", userAgentString);
        return userAgentString;
    }

    private static String getBrowserVersion() {
        String s = HlDataStatisticCommonParamsUtil.getSpValue("browser_version");
        if (!TextUtils.isEmpty((CharSequence)s)) {
            return s;
        }
        String userAgentString = HlDataStatisticCommonParamsUtil.getUa();
        UserAgent userAgent = new UserAgentParser().parse(userAgentString);
        String browserVersion = userAgent.getVersion();
        HlDataStatisticCommonParamsUtil.setSpValue("browser_version", browserVersion);
        return browserVersion;
    }

    private static String getIMEI() {
        return ImeiUtil.getImei((Context)sApplication);
    }

    private static String getIMSI() {
        return ImsiUtil.getImsi((Context)sApplication);
    }

    private static String getLib() {
        return "Android";
    }

    private static String getLibVersion() {
        return "V1.0";
    }

    private static String getSpValue(String key) {
        if (mSp == null) {
            mSp = sApplication.getSharedPreferences("hl_data_statistic", 0);
        }
        return mSp.getString(key, "");
    }

    private static void setSpValue(String key, String value) {
        if (mSp == null) {
            mSp = sApplication.getSharedPreferences("hl_data_statistic", 0);
        }
        mSp.edit().putString(key, value).apply();
    }
}

