/*
 * Decompiled with CFR 0.152.
 */
package com.helian.app.statistics.manager;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.widget.Toast;
import com.helian.app.statistics.init.HlDataStatisticInitializer;
import com.helian.app.statistics.manager.AliStatisticManager;
import com.helian.app.statistics.util.HlDataStatisticCommonParamsUtil;
import java.util.HashMap;
import java.util.Map;

public class HlDataStatisticManager {
    public static void userRegister(String userId) {
        AliStatisticManager.userRegister(userId);
    }

    public static void userLogin(String userId, String mobile) {
        try {
            AliStatisticManager.updateUserAccount(userId, mobile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void userLogout() {
        try {
            AliStatisticManager.clearUserAccount();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void onEvent(String pageName, String eventName) {
        HlDataStatisticManager.onEvent(pageName, eventName, null, null);
    }

    public static void onEvent(String pageName, String eventName, String key, String value) {
        HashMap<String, String> map = null;
        if (!TextUtils.isEmpty((CharSequence)key)) {
            map = new HashMap<String, String>(1);
            map.put(key, value);
        }
        HlDataStatisticManager.onEvent(pageName, eventName, map);
    }

    public static void onEvent(String pageName, String eventName, Map<String, String> properties) {
        HlDataStatisticManager.onEvent(pageName, eventName, 0L, properties);
    }

    public static void onEvent(String pageName, String eventName, long eventDuration, Map<String, String> properties) {
        try {
            Map<String, String> paramsMap = HlDataStatisticCommonParamsUtil.getParamsMap();
            if (properties != null) {
                paramsMap.putAll(properties);
            }
            AliStatisticManager.onEvent(eventName, eventDuration, pageName, paramsMap);
            if (HlDataStatisticInitializer.sIsShowToast) {
                String message = "eventName=" + eventName;
                if (properties != null && properties.size() > 0) {
                    message = message + "\\n params=" + properties.toString();
                }
                Toast.makeText((Context)HlDataStatisticInitializer.getApplication(), (CharSequence)message, (int)1).show();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setPageProperties(String pageName) {
        HlDataStatisticManager.setPageProperties(pageName, null);
    }

    public static void setPageProperties(String pageName, Map<String, String> map) {
        try {
            Map<String, String> paramsMap = HlDataStatisticCommonParamsUtil.getParamsMap();
            if (!TextUtils.isEmpty((CharSequence)pageName)) {
                paramsMap.put("page_name", pageName);
            }
            if (map != null) {
                paramsMap.putAll(map);
            }
            AliStatisticManager.setPageProperties(paramsMap);
            if (HlDataStatisticInitializer.sIsShowToast && map != null && map.size() > 0) {
                Toast.makeText((Context)HlDataStatisticInitializer.getApplication(), (CharSequence)map.toString(), (int)1).show();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setCustomPageProperties(String eventName, String referPageName, long duration, Map<String, String> properties) {
        try {
            Map<String, String> paramsMap = HlDataStatisticCommonParamsUtil.getParamsMap();
            if (!TextUtils.isEmpty((CharSequence)eventName)) {
                paramsMap.put("page_name", eventName);
            }
            if (properties != null) {
                paramsMap.putAll(properties);
            }
            AliStatisticManager.setCustomPageProperties(eventName, referPageName, duration, paramsMap);
            if (HlDataStatisticInitializer.sIsShowToast && properties != null && properties.size() > 0) {
                Toast.makeText((Context)HlDataStatisticInitializer.getApplication(), (CharSequence)properties.toString(), (int)1).show();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setCustomPageProperties(String eventName, String referPageName, long duration) {
        HlDataStatisticManager.setCustomPageProperties(eventName, referPageName, duration, null);
    }

    public static void pageAppear(Activity activity) {
        AliStatisticManager.pageAppear(activity);
    }

    public static void pageDisAppear(Activity activity) {
        AliStatisticManager.pageDisAppear(activity);
    }
}

