/*
 * Decompiled with CFR 0.152.
 */
package com.helian.app.statistics.manager;

import android.app.Activity;
import android.text.TextUtils;
import com.alibaba.sdk.android.man.MANAnalytics;
import com.alibaba.sdk.android.man.MANHitBuilders;
import com.alibaba.sdk.android.man.MANPageHitBuilder;
import com.alibaba.sdk.android.man.MANService;
import com.alibaba.sdk.android.man.MANServiceProvider;
import java.util.HashMap;
import java.util.Map;

public class AliStatisticManager {
    public static void userRegister(String userNick) {
        AliStatisticManager.getAnalytics().userRegister(userNick);
    }

    public static void updateUserAccount(String userNick, String userId) {
        AliStatisticManager.getAnalytics().updateUserAccount(userNick, userId);
    }

    public static void clearUserAccount() {
        AliStatisticManager.getAnalytics().updateUserAccount("", "");
    }

    public static void onEvent(String eventName, long eventDuration, String pageName, Map<String, String> properties) {
        MANHitBuilders.MANCustomHitBuilder utHitBuilder = new MANHitBuilders.MANCustomHitBuilder(eventName);
        if (eventDuration > 0L) {
            utHitBuilder.setDurationOnEvent(eventDuration);
        }
        if (!TextUtils.isEmpty((CharSequence)pageName)) {
            utHitBuilder.setEventPage(pageName);
        }
        if (properties != null && properties.size() > 0) {
            utHitBuilder.setProperties(properties);
        }
        AliStatisticManager.getAnalytics().getDefaultTracker().send(utHitBuilder.build());
    }

    public static void onEvent(String eventName) {
        AliStatisticManager.onEvent(eventName, 0L, null, null);
    }

    public static void onEvent(String eventName, String key, String value) {
        HashMap<String, String> map = null;
        if (!TextUtils.isEmpty((CharSequence)key)) {
            map = new HashMap<String, String>(1);
            map.put(key, value);
        }
        AliStatisticManager.onEvent(eventName, 0L, null, map);
    }

    public static void onEvent(String eventName, Map<String, String> properties) {
        AliStatisticManager.onEvent(eventName, 0L, null, properties);
    }

    public static void setPageProperties(Map<String, String> map) {
        if (map != null && map.size() > 0) {
            MANService manService = MANServiceProvider.getService();
            manService.getMANPageHitHelper().updatePageProperties(map);
        }
    }

    public static void setCustomPageProperties(String pageName, String referPageName, long duration, Map<String, String> properties) {
        MANPageHitBuilder pageHitBuilder = new MANPageHitBuilder(pageName);
        pageHitBuilder.setReferPage(referPageName);
        pageHitBuilder.setDurationOnPage(duration);
        pageHitBuilder.setProperties(properties);
        AliStatisticManager.getAnalytics().getDefaultTracker().send(pageHitBuilder.build());
    }

    public static void pageAppear(Activity activity) {
        MANService manService = MANServiceProvider.getService();
        manService.getMANPageHitHelper().pageAppear(activity);
    }

    public static void pageDisAppear(Activity activity) {
        MANService manService = MANServiceProvider.getService();
        manService.getMANPageHitHelper().pageDisAppear(activity);
    }

    private static MANAnalytics getAnalytics() {
        return MANServiceProvider.getService().getMANAnalytics();
    }
}

