package com.helian.app.statistics.manager;

import android.app.Activity;
import android.text.TextUtils;

import com.alibaba.sdk.android.man.MANAnalytics;
import com.alibaba.sdk.android.man.MANHitBuilders;
import com.alibaba.sdk.android.man.MANPageHitBuilder;
import com.alibaba.sdk.android.man.MANService;
import com.alibaba.sdk.android.man.MANServiceProvider;

import java.util.HashMap;
import java.util.Map;

/**
 * 类描述：
 * 创建时间：2018/8/21
 *
 * @author chaochao
 */
public class AliStatisticManager {

    /**
     *注册用户埋点
     */
    public static void userRegister(String userNick) {
        getAnalytics().userRegister(userNick);
    }

    /**
     *用户登录埋点
     */
    public static void updateUserAccount(String userNick,String userId) {
        getAnalytics().updateUserAccount(userNick, userId);
    }
    /**
     *用户注销埋点
     */
    public static void clearUserAccount() {
        getAnalytics().updateUserAccount("", "");
    }

    /**
     * 自定义事件(all)
     */
    public static void onEvent(String eventName,long eventDuration,String pageName,Map<String,
            String> properties) {
        MANHitBuilders.MANCustomHitBuilder utHitBuilder = new MANHitBuilders.MANCustomHitBuilder(eventName);
        if (eventDuration > 0) {
            utHitBuilder.setDurationOnEvent(eventDuration);
        }
        if (!TextUtils.isEmpty(pageName)) {
            utHitBuilder.setEventPage(pageName);
        }
        if (properties != null && properties.size() > 0) {
            utHitBuilder.setProperties(properties);
        }
        getAnalytics().getDefaultTracker().send(utHitBuilder.build());
    }

    /**
     * 事件无参数统计
     */
    public static void onEvent(String eventName) {
        onEvent(eventName,0,null,null);
    }
    /**
     * 事件附带单个属性
     */
    public static void onEvent(String eventName,String key,String value) {
        Map<String, String> map = null;
        if (!TextUtils.isEmpty(key)) {
            map = new HashMap<>(1);
            map.put(key,value);
        }
        onEvent(eventName,0,null,map);
    }
    /**
     * 事件附带多个属性
     */
    public static void onEvent(String eventName,Map<String,String> properties) {
        onEvent(eventName,0,null,properties);
    }

    /**
     * sdk自动对activity页面进行打点，onpause前配置页面属性。
     * @param map
     */
    public static void setPageProperties(Map<String,String> map) {
        if (map != null && map.size() > 0) {
            MANService manService = MANServiceProvider.getService();
            manService.getMANPageHitHelper().updatePageProperties(map);
        }
    }

    /**
     * 手动对fragment|view或某逻辑区间进行打点，可附带页面属性
     *
     */
    public static void setCustomPageProperties(String pageName,String referPageName,
                                               long duration ,Map<String,String> properties) {
        MANPageHitBuilder pageHitBuilder = new MANPageHitBuilder(pageName);
        pageHitBuilder.setReferPage(referPageName);
        pageHitBuilder.setDurationOnPage(duration);
        pageHitBuilder.setProperties(properties);
        getAnalytics().getDefaultTracker().send(pageHitBuilder.build());
    }

    public static void pageAppear(Activity activity) {
        MANService manService = MANServiceProvider.getService();
        manService.getMANPageHitHelper().pageAppear(activity);
    }

    public static void pageDisAppear(Activity activity) {
        MANService manService = MANServiceProvider.getService();
        manService.getMANPageHitHelper().pageDisAppear(activity);
    }



    private static MANAnalytics getAnalytics() {
        return  MANServiceProvider.getService().getMANAnalytics();
    }


}
