package com.helian.app.statistics.util;

import android.Manifest;
import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.webkit.WebSettings;
import android.webkit.WebView;

import com.helian.app.deviceid.DeviceIdManager;
import com.helian.app.deviceid.ImeiUtil;
import com.helian.app.deviceid.ImsiUtil;
import com.helian.app.statistics.util.ua.UserAgent;
import com.helian.app.statistics.util.ua.UserAgentParser;

import java.util.HashMap;
import java.util.Map;

import static com.helian.app.statistics.constant.Constants.KEY_AP_MAC;
import static com.helian.app.statistics.constant.Constants.KEY_BROWSER;
import static com.helian.app.statistics.constant.Constants.KEY_BROWSER_VERSION;
import static com.helian.app.statistics.constant.Constants.KEY_DEVICE_ID;
import static com.helian.app.statistics.constant.Constants.KEY_IMEI;
import static com.helian.app.statistics.constant.Constants.KEY_IMSI;
import static com.helian.app.statistics.constant.Constants.KEY_LIB;
import static com.helian.app.statistics.constant.Constants.KEY_LIB_VERSION;
import static com.helian.app.statistics.constant.Constants.KEY_MAC;
import static com.helian.app.statistics.constant.Constants.KEY_SCREEN_HEIGHT;
import static com.helian.app.statistics.constant.Constants.KEY_SCREEN_WIDTH;
import static com.helian.app.statistics.constant.Constants.KEY_SN;
import static com.helian.app.statistics.constant.Constants.KEY_STATION_ID;
import static com.helian.app.statistics.constant.Constants.KEY_UA;
import static com.helian.app.statistics.constant.Constants.SDK_VERSION;

/**
 * 类描述：
 * 创建时间：2019/8/14
 *
 * @author chaochao
 */
public class HlDataStatisticCommonParamsUtil {

    private static Context sApplication;
    private static SharedPreferences mSp;
    private static String sStationId;
    private static String sSn;

    public static Map<String,String> getParamsMap(Context context) {
        sApplication = context.getApplicationContext();
        HashMap<String,String> map = new HashMap<>();
        map.put(KEY_DEVICE_ID,getDeviceId());
        map.put(KEY_MAC,getMac());
        map.put(KEY_STATION_ID,getStationId());
        map.put(KEY_SN,getSn());
        map.put(KEY_AP_MAC,getApMac());
        map.put(KEY_SCREEN_WIDTH,getScreenWidth());
        map.put(KEY_SCREEN_HEIGHT,getScreenHeight());
        map.put(KEY_BROWSER,getBrowser(context));
        map.put(KEY_UA,getUa(context));
        map.put(KEY_BROWSER_VERSION,getBrowserVersion(context));
        map.put(KEY_LIB,getLib());
        map.put(KEY_LIB_VERSION,getLibVersion());
        map.put(KEY_IMEI,getIMEI());
        map.put(KEY_IMSI,getIMSI());
        return map;
    }

    private static String getDeviceId() {
        return DeviceIdManager.getInstance().getDeviceId();
    }

    private static String getMac() {
        return DeviceInfoUtil.getMac(sApplication);
    }

    private static String getStationId() {
        return sStationId;
    }

    /**
     * 设置医院id
     */
    public static void updateStationId(String stationId) {
        sStationId = stationId;
    }

    private static String getSn() {
        return sSn;
    }

    /**
     * 设置默认网关
     */
    public static void updateSn(String sn) {
        sSn = sn;
    }

    private static String getApMac() {
        if (ContextCompat.checkSelfPermission(sApplication, Manifest.permission.ACCESS_FINE_LOCATION)
                != PackageManager.PERMISSION_GRANTED) {
            return null;
        }
        WifiManager systemService = (WifiManager) sApplication.getSystemService(Context.WIFI_SERVICE);
        WifiInfo connectionInfo = systemService.getConnectionInfo();
        if (connectionInfo != null) {
            return connectionInfo.getBSSID();
        }
        return "";
    }

    private static String getScreenWidth() {
        String s = getSpValue(KEY_SCREEN_WIDTH);
        if (!TextUtils.isEmpty(s)) {
            return s;
        } else {
            String s1 = String.valueOf(DeviceInfoUtil.getScreenWith(sApplication));
            setSpValue(KEY_SCREEN_WIDTH,s1);
            return s1;
        }
    }

    private static String getScreenHeight() {
        String s = getSpValue(KEY_SCREEN_HEIGHT);
        if (!TextUtils.isEmpty(s)) {
            return s;
        } else {
            String s1 = String.valueOf(DeviceInfoUtil.getScreenHeight(sApplication));
            setSpValue(KEY_SCREEN_HEIGHT,s1);
            return s1;
        }
    }

    private static String getBrowser(Context context) {
        String s = getSpValue(KEY_BROWSER);
        if (!TextUtils.isEmpty(s)) {
            return s;
        } else {
            String userAgentString = getUa(context);
            String browser = new UserAgentParser().browser(userAgentString);
            setSpValue(KEY_BROWSER,browser);
            return browser;
        }
    }

    private static String getUa(Context context) {
        String s = getSpValue(KEY_UA);
        if (!TextUtils.isEmpty(s)) {
            return s;
        } else {
            WebSettings settings = new WebView(context).getSettings();
            String userAgentString = settings.getUserAgentString();
            setSpValue(KEY_UA,userAgentString);
            return userAgentString;
        }
    }

    private static String getBrowserVersion(Context context) {
        String s = getSpValue(KEY_BROWSER_VERSION);
        if (!TextUtils.isEmpty(s)) {
            return s;
        } else {
            String userAgentString = getUa(context);
            UserAgent userAgent = new UserAgentParser().parse(userAgentString);
            String browserVersion = userAgent.getVersion();
            setSpValue(KEY_BROWSER_VERSION,browserVersion);
            return browserVersion;
        }
    }

    private static String getIMEI() {
        return ImeiUtil.getImei(sApplication);
    }

    private static String getIMSI() {
        return ImsiUtil.getImsi(sApplication);
    }

    private static String getLib() {
        return "Android";
    }

    private static String getLibVersion() {
        return SDK_VERSION;
    }

    private static String getSpValue(String key) {
        if (mSp == null) {
            mSp = sApplication.getSharedPreferences("hl_data_statistic", Activity.MODE_PRIVATE);
        }
        return mSp.getString(key,"");
    }

    private static void setSpValue(String key,String value) {
        if (mSp == null) {
            mSp = sApplication.getSharedPreferences("hl_data_statistic", Activity.MODE_PRIVATE);
        }
        mSp.edit().putString(key,value).apply();
    }


}
