package com.helian.app.statistics.manager;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;

import com.helian.app.statistics.util.HlDataStatisticCommonParamsUtil;

import java.util.HashMap;
import java.util.Map;

/**
 * 类描述：
 * 创建时间：2019/8/14
 *
 * @author chaochao
 */
public class HlDataStatisticManager {

    /**用户**/

    public static void userRegister(String userId) {
        AliStatisticManager.userRegister(userId);
    }

    public static void userLogin(String userId, String mobile) {
        AliStatisticManager.updateUserAccount(userId, mobile);
    }

    public static void userLogout() {
        AliStatisticManager.clearUserAccount();
    }

    /** 埋点事件**/

    public static void onEvent(Context context,String pageName,String eventId) {
        onEvent(context,pageName,eventId,null,null);
    }

    public static void onEvent(Context context,String pageName,String eventId,String key,String value) {
        HashMap<String, String> map = null;
        if (!TextUtils.isEmpty(key)) {
            map = new HashMap<>(1);
            map.put(key,value);
        }
        onEvent(context,pageName,eventId,map);
    }

    public static void onEvent(Context context,String pageName,String eventId,Map<String,String> properties) {
        onEvent(context,pageName,eventId,0,properties);
    }

    /**
     * @param context 页面上下文
     * @param eventId 事件key名
     * @param eventDuration 事件时间区间
     * @param properties 事件额外参数
     */
    public static void onEvent(Context context,String pageName,String eventId, long eventDuration,Map<String, String> properties) {

        Map<String,String> paramsMap = HlDataStatisticCommonParamsUtil.getParamsMap(context);
        if (properties != null) {
            paramsMap.putAll(properties);
        }
        AliStatisticManager.onEvent(eventId,eventDuration, pageName,paramsMap);
    }

    /**公共参数**/

    public static void setPageProperties(Context context,String pageName) {
        setPageProperties(context,pageName,null);
    }

    public static void setPageProperties(Context context,String pageName,Map<String,String> map) {
        Map<String,String> paramsMap = HlDataStatisticCommonParamsUtil.getParamsMap(context);

        if (!TextUtils.isEmpty(pageName)) {
            paramsMap.put("page_name",pageName);
        }
        if (map != null) {
            paramsMap.putAll(map);
        }

        AliStatisticManager.setPageProperties(paramsMap);
    }


    /**
     * @param context 页面上下午
     * @param pageName pv页面名称
     * @param referPageName 前一个页面名称
     * @param duration pv时间区间
     * @param properties pv自定义参数
     */
    public static void setCustomPageProperties(Context context,String pageName, String referPageName,
                                               long duration ,Map<String,String> properties) {
        Map<String,String> paramsMap = HlDataStatisticCommonParamsUtil.getParamsMap(context);
        if (properties != null) {
            paramsMap.putAll(properties);
        }
        AliStatisticManager.setCustomPageProperties(pageName,referPageName,duration,paramsMap);
    }

    public static void setCustomPageProperties(Activity activity,String pageName, String referPageName,
                                               long duration) {
        setCustomPageProperties(activity,pageName,referPageName,duration,null);
    }

    public static void pageAppear(Activity activity) {
        AliStatisticManager.pageAppear(activity);
    }

    public static void pageDisAppear(Activity activity) {
        AliStatisticManager.pageDisAppear(activity);
    }
}
