/*
 * Decompiled with CFR 0.152.
 */
package com.helian.app.statistics.init;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import com.alibaba.sdk.android.man.MANService;
import com.alibaba.sdk.android.man.MANServiceProvider;
import com.helian.app.deviceid.DeviceIdManager;
import com.helian.app.statistics.manager.HlDataStatisticCommonBizMananger;
import com.helian.app.statistics.manager.HlDataStatisticManager;
import com.helian.app.statistics.util.AppInfoUtil;
import com.helian.app.statistics.util.PageNameUtil;

public class HlDataStatisticInitializer {
    private static boolean isCurrentRunningForeground = true;
    private static Application sApplication;

    public static Application getApplication() {
        return sApplication;
    }

    public static class Builder {
        private Application application;
        private boolean isDebug;
        private String channel;
        private String appKey;
        private String appSecret;

        public Builder(Application application) {
            this.application = application;
            sApplication = application;
        }

        public Builder setIsDebug(boolean isDebug) {
            this.isDebug = isDebug;
            return this;
        }

        public Builder setChannel(String channel) {
            this.channel = channel;
            return this;
        }

        public Builder setAppKey(String appKey) {
            this.appKey = appKey;
            return this;
        }

        public Builder setAppSecret(String appSecret) {
            this.appSecret = appSecret;
            return this;
        }

        public void build() {
            if (this.application == null) {
                return;
            }
            MANService manService = MANServiceProvider.getService();
            if (this.isDebug) {
                manService.getMANAnalytics().turnOnDebug();
                manService.getMANAnalytics().turnOffCrashReporter();
            }
            if (!TextUtils.isEmpty((CharSequence)this.appKey) && !TextUtils.isEmpty((CharSequence)this.appSecret)) {
                manService.getMANAnalytics().init(this.application, this.application.getApplicationContext(), this.appKey, this.appSecret);
            } else {
                manService.getMANAnalytics().init(this.application, this.application.getApplicationContext());
            }
            manService.getMANAnalytics().setChannel(this.channel);
            manService.getMANAnalytics().setAppVersion(AppInfoUtil.getAppVersionName((Context)this.application));
            DeviceIdManager.getInstance().init((Context)this.application);
            this.initActivityLife(this.application);
        }

        private void initActivityLife(Application application) {
            HlDataStatisticCommonBizMananger.startAppEvent((Context)application);
            application.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

                public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
                    HlDataStatisticManager.setPageProperties(activity, PageNameUtil.getNameByAnnotation(activity));
                }

                public void onActivityStarted(Activity activity) {
                }

                public void onActivityResumed(Activity activity) {
                    if (!isCurrentRunningForeground) {
                        HlDataStatisticCommonBizMananger.activeAppEvent((Context)activity);
                        isCurrentRunningForeground = true;
                    }
                }

                public void onActivityPaused(Activity activity) {
                }

                public void onActivityStopped(Activity activity) {
                    isCurrentRunningForeground = AppInfoUtil.isRunningForeground(activity.getApplication());
                }

                public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
                }

                public void onActivityDestroyed(Activity activity) {
                }
            });
        }
    }
}

