package com.helian.app.statistics.manager;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;

import com.helian.app.statistics.annotation.PageName;
import com.helian.app.statistics.util.HlDataStatisticCommonParamsUtil;

import java.util.HashMap;
import java.util.Map;

/**
 * 类描述：
 * 创建时间：2019/8/14
 *
 * @author chaochao
 */
public class HlDataStatisticManager {

    /**用户**/

    public static void userRegister(String userId) {
        AliStatisticManager.userRegister(userId);
    }

    public static void userLogin(String userId, String mobile) {
        AliStatisticManager.updateUserAccount(userId, mobile);
    }

    public static void userLogout() {
        AliStatisticManager.clearUserAccount();
    }

    /** 埋点事件**/

    public static void onEvent(Context context,String eventId) {
        onEvent(context,eventId,null,null);
    }

    public static void onEvent(Context context,String eventId,String key,String value) {
        HashMap<String, String> map = null;
        if (!TextUtils.isEmpty(key)) {
            map = new HashMap<>(1);
            map.put(key,value);
        }
        onEvent(context,eventId,map);
    }

    public static void onEvent(Context context,String eventId,Map<String,String> properties) {
        onEvent(context,eventId,0,properties);
    }

    public static void onEvent(Context context,String eventId, long eventDuration,Map<String, String> properties) {
        String pageName = "";
        if (context != null) {
            PageName annotation = context.getClass().getAnnotation(PageName.class);
            if (annotation != null) {
                pageName = annotation.value();
            }
        }
        Map<String,String> paramsMap = HlDataStatisticCommonParamsUtil.getParamsMap(context);
        if (properties != null) {
            paramsMap.putAll(properties);
        }
        AliStatisticManager.onEvent(eventId,eventDuration,pageName,paramsMap);
    }

    /**公共参数**/

    /**
     * @param context pagename配置在Activity AndroidManifest中配置activity的label字段
     * @param map 页面额外添加的字段
     */
    public static void setPageProperties(Context context,String pageName, Map<String,String> map) {
        Map<String,String> paramsMap = HlDataStatisticCommonParamsUtil.getParamsMap(context);
        if (!TextUtils.isEmpty(pageName)) {
            paramsMap.put("page_name",pageName);
        }
        if (map != null) {
            paramsMap.putAll(map);
        }

        AliStatisticManager.setPageProperties(paramsMap);
    }

    public static void setPageProperties(Activity activity,String pageName) {
        setPageProperties(activity,pageName,null);
    }

    public static void setCustomPageProperties(Activity activity,String pageName, String referPageName,
                                               long duration ,Map<String,String> properties) {
        Map<String,String> paramsMap = HlDataStatisticCommonParamsUtil.getParamsMap(activity);
        if (properties != null) {
            paramsMap.putAll(properties);
        }
        AliStatisticManager.setCustomPageProperties(pageName,referPageName,duration,paramsMap);
    }

    public static void setCustomPageProperties(Activity activity,String pageName, String referPageName,
                                               long duration) {
        setCustomPageProperties(activity,pageName,referPageName,duration,null);
    }
}
