/*
 * Decompiled with CFR 0.152.
 */
package com.heliandoctor.app.push.xiaomi;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Process;
import android.text.TextUtils;
import android.util.Log;
import com.heliandoctor.app.push.PushInitContract;
import com.heliandoctor.app.push.util.DeviceInfoUtil;
import com.xiaomi.mipush.sdk.MiPushClient;
import java.util.List;

public class XiaomiPushInitializer
implements PushInitContract {
    private Context mContext;
    private String mAppId;
    private String mAppKey;

    public XiaomiPushInitializer(Context context, String appId, String appKey) {
        this.mContext = context;
        this.mAppId = appId;
        this.mAppKey = appKey;
    }

    @Override
    public void init() {
        if (this.xiaomiShouldInit() && !TextUtils.isEmpty((CharSequence)this.mAppId) && !TextUtils.isEmpty((CharSequence)this.mAppKey)) {
            MiPushClient.registerPush((Context)this.mContext, (String)this.mAppId, (String)this.mAppKey);
        }
        this.log();
    }

    @Override
    public boolean checkEnable() {
        if (DeviceInfoUtil.isXiaomi() && !TextUtils.isEmpty((CharSequence)this.mAppId) && !TextUtils.isEmpty((CharSequence)this.mAppKey)) {
            return true;
        }
        this.log();
        return false;
    }

    private void log() {
        if (TextUtils.isEmpty((CharSequence)this.mAppId)) {
            Log.e((String)"pushConfigParams", (String)"default xiaomi push appId");
        }
        if (TextUtils.isEmpty((CharSequence)this.mAppKey)) {
            Log.e((String)"pushConfigParams", (String)"default xiaomi push appKey");
        }
    }

    private boolean xiaomiShouldInit() {
        ActivityManager am = (ActivityManager)this.mContext.getSystemService("activity");
        List processInfos = am.getRunningAppProcesses();
        String mainProcessName = this.mContext.getPackageName();
        int myPid = Process.myPid();
        if (processInfos != null && processInfos.size() > 0) {
            for (ActivityManager.RunningAppProcessInfo info : processInfos) {
                if (info.pid != myPid || !mainProcessName.equals(info.processName)) continue;
                return true;
            }
        }
        return false;
    }
}

