/*
 * Decompiled with CFR 0.152.
 */
package com.heliandoctor.app.push.xiaomi;

import android.app.NotificationManager;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.heliandoctor.app.push.util.SendBroadcastUtil;
import com.xiaomi.mipush.sdk.MiPushCommandMessage;
import com.xiaomi.mipush.sdk.MiPushMessage;
import com.xiaomi.mipush.sdk.PushMessageReceiver;
import java.util.List;

public class XiaoMiPushReceive
extends PushMessageReceiver {
    private final String TAG = "XiaoMiPushReceive";
    private String mRegId;
    private String mTopic;
    private String mAlias;
    private String mAccount;
    private String mStartTime;
    private String mEndTime;
    NotificationManager notificationManager;

    public void onReceivePassThroughMessage(Context context, MiPushMessage message) {
        Log.v((String)"XiaoMiPushReceive", (String)("onReceivePassThroughMessage is called. " + message.toString()));
        if (!TextUtils.isEmpty((CharSequence)message.getTopic())) {
            this.mTopic = message.getTopic();
        } else if (!TextUtils.isEmpty((CharSequence)message.getAlias())) {
            this.mAlias = message.getAlias();
        }
        SendBroadcastUtil.sendPassThroughEvent(context, message.getContent(), message.getTitle());
    }

    public void onNotificationMessageClicked(Context context, MiPushMessage message) {
        Log.v((String)"XiaoMiPushReceive", (String)("onNotificationMessageClicked is called. " + message.toString()));
        if (!TextUtils.isEmpty((CharSequence)message.getTopic())) {
            this.mTopic = message.getTopic();
        } else if (!TextUtils.isEmpty((CharSequence)message.getAlias())) {
            this.mAlias = message.getAlias();
        }
        SendBroadcastUtil.sendPushClickEvent(context, message.getContent(), message.getTitle());
    }

    public void onNotificationMessageArrived(Context context, MiPushMessage message) {
        Log.v((String)"XiaoMiPushReceive", (String)("onNotificationMessageArrived is called. " + message.toString()));
        if (!TextUtils.isEmpty((CharSequence)message.getTopic())) {
            this.mTopic = message.getTopic();
        } else if (!TextUtils.isEmpty((CharSequence)message.getAlias())) {
            this.mAlias = message.getAlias();
        }
        SendBroadcastUtil.sendPushArrivedEvent(context, message.getContent(), message.getTitle());
    }

    public void onCommandResult(Context context, MiPushCommandMessage message) {
        String cmdArg2;
        Log.v((String)"XiaoMiPushReceive", (String)("onCommandResult is called. " + message.toString()));
        String command = message.getCommand();
        List arguments = message.getCommandArguments();
        String cmdArg1 = arguments != null && arguments.size() > 0 ? (String)arguments.get(0) : null;
        String string = cmdArg2 = arguments != null && arguments.size() > 1 ? (String)arguments.get(1) : null;
        if ("register".equals(command)) {
            if (message.getResultCode() == 0L) {
                this.mRegId = cmdArg1;
                SendBroadcastUtil.sendPushId(context, this.mRegId);
            }
        } else if ("set-alias".equals(command)) {
            if (message.getResultCode() == 0L) {
                this.mAlias = cmdArg1;
            }
        } else if ("unset-alias".equals(command)) {
            if (message.getResultCode() == 0L) {
                this.mAlias = cmdArg1;
            }
        } else if ("set-account".equals(command)) {
            if (message.getResultCode() == 0L) {
                this.mAccount = cmdArg1;
            }
        } else if ("unset-account".equals(command)) {
            if (message.getResultCode() == 0L) {
                this.mAccount = cmdArg1;
            }
        } else if ("subscribe-topic".equals(command)) {
            if (message.getResultCode() == 0L) {
                this.mTopic = cmdArg1;
            }
        } else if ("unsubscibe-topic".equals(command)) {
            if (message.getResultCode() == 0L) {
                this.mTopic = cmdArg1;
            }
        } else if ("accept-time".equals(command) && message.getResultCode() == 0L) {
            this.mStartTime = cmdArg1;
            this.mEndTime = cmdArg2;
        }
    }

    public void onReceiveRegisterResult(Context context, MiPushCommandMessage message) {
        String cmdArg1;
        Log.v((String)"XiaoMiPushReceive", (String)("onReceiveRegisterResult is called. " + message.toString()));
        String command = message.getCommand();
        List arguments = message.getCommandArguments();
        String string = cmdArg1 = arguments != null && arguments.size() > 0 ? (String)arguments.get(0) : null;
        if ("register".equals(command) && message.getResultCode() == 0L) {
            this.mRegId = cmdArg1;
        }
    }
}

