/*
 * Decompiled with CFR 0.152.
 */
package com.heliandoctor.app.push.oppo;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.coloros.mcssdk.PushManager;
import com.coloros.mcssdk.callback.PushCallback;
import com.heliandoctor.app.push.PushInitContract;
import com.heliandoctor.app.push.oppo.PushCallbackOnRegister;
import com.heliandoctor.app.push.util.DeviceInfoUtil;
import com.heliandoctor.app.push.util.SendBroadcastUtil;

public class OppoPushInitializer
implements PushInitContract {
    private final Context mContext;
    private final String mAppKey;
    private final String mAppSecret;

    public OppoPushInitializer(Context context, String appKey, String appSecret) {
        this.mContext = context;
        this.mAppKey = appKey;
        this.mAppSecret = appSecret;
    }

    @Override
    public void init() {
        try {
            this.initOppo();
            this.log();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean checkEnable() {
        if (DeviceInfoUtil.isOppo() && !TextUtils.isEmpty((CharSequence)this.mAppKey) && !TextUtils.isEmpty((CharSequence)this.mAppSecret)) {
            return true;
        }
        this.log();
        return false;
    }

    private void log() {
        if (TextUtils.isEmpty((CharSequence)this.mAppKey)) {
            Log.e((String)"pushConfigParams", (String)"default oppo push appKey");
        }
        if (TextUtils.isEmpty((CharSequence)this.mAppSecret)) {
            Log.e((String)"pushConfigParams", (String)"default oppo push appSecret");
        }
    }

    private void initOppo() {
        if (!PushManager.isSupportPush((Context)this.mContext) || TextUtils.isEmpty((CharSequence)this.mAppKey) || TextUtils.isEmpty((CharSequence)this.mAppSecret)) {
            return;
        }
        PushManager.getInstance().register(this.mContext, this.mAppKey, this.mAppSecret, (PushCallback)new PushCallbackOnRegister(){

            @Override
            public void onRegister(int i, String s) {
                if (0 == i) {
                    Log.v((String)"oppoPushId", (String)s);
                    SendBroadcastUtil.sendPushId(OppoPushInitializer.this.mContext, s);
                } else {
                    PushManager.getInstance().getRegister();
                }
            }
        });
    }
}

