/*
 * Decompiled with CFR 0.152.
 */
package com.heliandoctor.app.push.oppo;

import android.content.Context;
import android.content.Intent;
import java.net.URISyntaxException;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class MessageDispatcher {
    public static void dispatch(Context ctx, String content) {
        Intent intent = null;
        try {
            intent = Intent.parseUri((String)content, (int)1);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        try {
            if (!MessageDispatcher.isSupportByIntent(ctx, intent)) {
                if (MessageDispatcher.isJson(content)) {
                    MessageDispatcher.handleSptMsg(ctx, content);
                } else if (content.startsWith("command")) {
                    MessageDispatcher.handleCustomerMsg(ctx, content);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void handleCustomerMsg(Context ctx, String msg) {
    }

    private static void handleSptMsg(Context ctx, String msg) throws JSONException {
        JSONObject json = new JSONObject(msg);
        String actionUrl = json.optString("actionUrl");
        String actionActivity = json.optString("actionActivity");
        String logoUrl = json.optString("logoUrl");
        String title = json.optString("title");
        String content = json.optString("content");
        JSONObject actionParams = json.optJSONObject("actionParams");
    }

    private static boolean isSupportByIntent(Context context, Intent intent) {
        if (intent == null) {
            return false;
        }
        List list = context.getPackageManager().queryIntentActivities(intent, 65536);
        return list != null && list.size() > 0;
    }

    private static boolean isJson(String json) {
        try {
            JSONObject object = new JSONObject(json);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

