/*
 * Decompiled with CFR 0.152.
 */
package com.heliandoctor.app.push.huawei.api.common;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import com.heliandoctor.app.push.huawei.api.common.HMSAgentLog;
import com.heliandoctor.app.push.huawei.api.common.IActivityDestroyedCallback;
import com.heliandoctor.app.push.huawei.api.common.IActivityPauseCallback;
import com.heliandoctor.app.push.huawei.api.common.IActivityResumeCallback;
import com.heliandoctor.app.push.huawei.api.common.StrUtils;
import java.util.ArrayList;
import java.util.List;

public final class ActivityMgr
implements Application.ActivityLifecycleCallbacks {
    public static final ActivityMgr INST = new ActivityMgr();
    private static final Object LOCK_LASTACTIVITIES = new Object();
    private Application application;
    private List<Activity> curActivities = new ArrayList<Activity>();
    private List<IActivityResumeCallback> resumeCallbacks = new ArrayList<IActivityResumeCallback>();
    private List<IActivityPauseCallback> pauseCallbacks = new ArrayList<IActivityPauseCallback>();
    private List<IActivityDestroyedCallback> destroyedCallbacks = new ArrayList<IActivityDestroyedCallback>();

    private ActivityMgr() {
    }

    public void init(Application app, Activity initActivity) {
        HMSAgentLog.d("init");
        if (this.application != null) {
            this.application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        }
        this.application = app;
        this.setCurActivity(initActivity);
        app.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
    }

    public void release() {
        HMSAgentLog.d("release");
        if (this.application != null) {
            this.application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        }
        this.clearCurActivities();
        this.clearActivitResumeCallbacks();
        this.clearActivitPauseCallbacks();
        this.application = null;
    }

    public void registerActivitResumeEvent(IActivityResumeCallback callback) {
        HMSAgentLog.d("registerOnResume:" + StrUtils.objDesc(callback));
        this.resumeCallbacks.add(callback);
    }

    public void unRegisterActivitResumeEvent(IActivityResumeCallback callback) {
        HMSAgentLog.d("unRegisterOnResume:" + StrUtils.objDesc(callback));
        this.resumeCallbacks.remove(callback);
    }

    public void registerActivitPauseEvent(IActivityPauseCallback callback) {
        HMSAgentLog.d("registerOnPause:" + StrUtils.objDesc(callback));
        this.pauseCallbacks.add(callback);
    }

    public void unRegisterActivitPauseEvent(IActivityPauseCallback callback) {
        HMSAgentLog.d("unRegisterOnPause:" + StrUtils.objDesc(callback));
        this.pauseCallbacks.remove(callback);
    }

    public void registerActivitDestroyedEvent(IActivityDestroyedCallback callback) {
        HMSAgentLog.d("registerOnDestroyed:" + StrUtils.objDesc(callback));
        this.destroyedCallbacks.add(callback);
    }

    public void unRegisterActivitDestroyedEvent(IActivityDestroyedCallback callback) {
        HMSAgentLog.d("unRegisterOnDestroyed:" + StrUtils.objDesc(callback));
        this.destroyedCallbacks.remove(callback);
    }

    public void clearActivitResumeCallbacks() {
        HMSAgentLog.d("clearOnResumeCallback");
        this.resumeCallbacks.clear();
    }

    public void clearActivitPauseCallbacks() {
        HMSAgentLog.d("clearOnPauseCallback");
        this.pauseCallbacks.clear();
    }

    public Activity getLastActivity() {
        return this.getLastActivityInner();
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        HMSAgentLog.d("onCreated:" + StrUtils.objDesc(activity));
        this.setCurActivity(activity);
    }

    public void onActivityStarted(Activity activity) {
        HMSAgentLog.d("onStarted:" + StrUtils.objDesc(activity));
        this.setCurActivity(activity);
    }

    public void onActivityResumed(Activity activity) {
        HMSAgentLog.d("onResumed:" + StrUtils.objDesc(activity));
        this.setCurActivity(activity);
        ArrayList<IActivityResumeCallback> tmdCallbacks = new ArrayList<IActivityResumeCallback>(this.resumeCallbacks);
        for (IActivityResumeCallback callback : tmdCallbacks) {
            callback.onActivityResume(activity);
        }
    }

    public void onActivityPaused(Activity activity) {
        HMSAgentLog.d("onPaused:" + StrUtils.objDesc(activity));
        ArrayList<IActivityPauseCallback> tmdCallbacks = new ArrayList<IActivityPauseCallback>(this.pauseCallbacks);
        for (IActivityPauseCallback callback : tmdCallbacks) {
            callback.onActivityPause(activity);
        }
    }

    public void onActivityStopped(Activity activity) {
        HMSAgentLog.d("onStopped:" + StrUtils.objDesc(activity));
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
        HMSAgentLog.d("onDestroyed:" + StrUtils.objDesc(activity));
        this.removeActivity(activity);
        ArrayList<IActivityDestroyedCallback> tmdCallbacks = new ArrayList<IActivityDestroyedCallback>(this.destroyedCallbacks);
        for (IActivityDestroyedCallback callback : tmdCallbacks) {
            callback.onActivityDestroyed(activity, this.getLastActivityInner());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeActivity(Activity curActivity) {
        Object object = LOCK_LASTACTIVITIES;
        synchronized (object) {
            this.curActivities.remove(curActivity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCurActivity(Activity curActivity) {
        Object object = LOCK_LASTACTIVITIES;
        synchronized (object) {
            int idxCurActivity = this.curActivities.indexOf(curActivity);
            if (idxCurActivity == -1) {
                this.curActivities.add(curActivity);
            } else if (idxCurActivity < this.curActivities.size() - 1) {
                this.curActivities.remove(curActivity);
                this.curActivities.add(curActivity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Activity getLastActivityInner() {
        Object object = LOCK_LASTACTIVITIES;
        synchronized (object) {
            if (this.curActivities.size() > 0) {
                return this.curActivities.get(this.curActivities.size() - 1);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCurActivities() {
        Object object = LOCK_LASTACTIVITIES;
        synchronized (object) {
            this.curActivities.clear();
        }
    }
}

