/*
 * Decompiled with CFR 0.152.
 */
package com.heliandoctor.app.push.huawei.api;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.widget.Toast;
import com.heliandoctor.app.push.huawei.api.common.ActivityMgr;
import com.heliandoctor.app.push.huawei.api.common.ApiClientMgr;
import com.heliandoctor.app.push.huawei.api.common.CheckUpdateApi;
import com.heliandoctor.app.push.huawei.api.common.HMSAgentLog;
import com.heliandoctor.app.push.huawei.api.common.IClientConnectCallback;
import com.heliandoctor.app.push.huawei.api.common.INoProguard;
import com.heliandoctor.app.push.huawei.api.common.handler.CheckUpdateHandler;
import com.heliandoctor.app.push.huawei.api.common.handler.ConnectHandler;
import com.heliandoctor.app.push.huawei.api.push.DeleteTokenApi;
import com.heliandoctor.app.push.huawei.api.push.EnableReceiveNormalMsgApi;
import com.heliandoctor.app.push.huawei.api.push.EnableReceiveNotifyMsgApi;
import com.heliandoctor.app.push.huawei.api.push.GetPushStateApi;
import com.heliandoctor.app.push.huawei.api.push.GetTokenApi;
import com.heliandoctor.app.push.huawei.api.push.QueryAgreementApi;
import com.heliandoctor.app.push.huawei.api.push.handler.DeleteTokenHandler;
import com.heliandoctor.app.push.huawei.api.push.handler.EnableReceiveNormalMsgHandler;
import com.heliandoctor.app.push.huawei.api.push.handler.EnableReceiveNotifyMsgHandler;
import com.heliandoctor.app.push.huawei.api.push.handler.GetPushStateHandler;
import com.heliandoctor.app.push.huawei.api.push.handler.GetTokenHandler;
import com.heliandoctor.app.push.huawei.api.push.handler.QueryAgreementHandler;
import com.huawei.hms.api.HuaweiApiClient;

public final class HMSAgent
implements INoProguard {
    private static final String VER_020503001 = "020503001";
    private static final String VER_020600001 = "020600001";
    private static final String VER_020600200 = "020600200";
    private static final String VER_020601002 = "020601002";
    public static final String CURVER = "020601002";

    private HMSAgent() {
    }

    private static boolean checkSDKVersion(Context context) {
        long sdkMainVerL = 20601L;
        long agentMainVerL = Long.parseLong("020601002") / 1000L;
        if (sdkMainVerL != agentMainVerL) {
            String errMsg = "error: HMSAgent major version code (" + agentMainVerL + ") does not match HMSSDK major version code (" + sdkMainVerL + ")";
            HMSAgentLog.e(errMsg);
            Toast.makeText((Context)context, (CharSequence)errMsg, (int)1).show();
            return false;
        }
        return true;
    }

    public static boolean init(Activity activity) {
        return HMSAgent.init(null, activity);
    }

    public static boolean init(Application app) {
        return HMSAgent.init(app, null);
    }

    public static boolean init(Application app, Activity activity) {
        Application appTmp = app;
        Activity activityTmp = activity;
        if (appTmp == null && activityTmp == null) {
            HMSAgentLog.e("the param of method HMSAgent.init can not be null !!!");
            return false;
        }
        if (appTmp == null) {
            appTmp = activityTmp.getApplication();
        }
        if (appTmp == null) {
            HMSAgentLog.e("the param of method HMSAgent.init app can not be null !!!");
            return false;
        }
        if (activityTmp != null && activityTmp.isFinishing()) {
            activityTmp = null;
        }
        if (!HMSAgent.checkSDKVersion((Context)appTmp)) {
            return false;
        }
        HMSAgentLog.i("init HMSAgent 020601002 with hmssdkver 20601301");
        ActivityMgr.INST.init(appTmp, activityTmp);
        ApiClientMgr.INST.init(appTmp);
        return true;
    }

    public static void destroy() {
        HMSAgentLog.i("destroy HMSAgent");
        ActivityMgr.INST.release();
        ApiClientMgr.INST.release();
    }

    public static void connect(Activity activity, final ConnectHandler callback) {
        HMSAgentLog.i("start connect");
        ApiClientMgr.INST.connect(new IClientConnectCallback(){

            @Override
            public void onConnect(final int rst, HuaweiApiClient client) {
                if (callback != null) {
                    new Handler(Looper.getMainLooper()).post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onConnect(rst);
                        }
                    });
                }
            }
        }, true);
    }

    public static void checkUpdate(Activity activity, CheckUpdateHandler callback) {
        new CheckUpdateApi().checkUpdate(activity, callback);
    }

    public static final class Push {
        public static void getToken(GetTokenHandler handler) {
            new GetTokenApi().getToken(handler);
        }

        public static void deleteToken(String token, DeleteTokenHandler handler) {
            new DeleteTokenApi().deleteToken(token, handler);
        }

        public static void getPushState(GetPushStateHandler handler) {
            new GetPushStateApi().getPushState(handler);
        }

        public static void enableReceiveNotifyMsg(boolean enable, EnableReceiveNotifyMsgHandler handler) {
            new EnableReceiveNotifyMsgApi().enableReceiveNotifyMsg(enable, handler);
        }

        public static void enableReceiveNormalMsg(boolean enable, EnableReceiveNormalMsgHandler handler) {
            new EnableReceiveNormalMsgApi().enableReceiveNormalMsg(enable, handler);
        }

        public static void queryAgreement(QueryAgreementHandler handler) {
            new QueryAgreementApi().queryAgreement(handler);
        }
    }

    public static final class AgentResultCode {
        public static final int HMSAGENT_SUCCESS = 0;
        public static final int HMSAGENT_NO_INIT = -1000;
        public static final int NO_ACTIVITY_FOR_USE = -1001;
        public static final int RESULT_IS_NULL = -1002;
        public static final int STATUS_IS_NULL = -1003;
        public static final int START_ACTIVITY_ERROR = -1004;
        public static final int ON_ACTIVITY_RESULT_ERROR = -1005;
        public static final int REQUEST_REPEATED = -1006;
        public static final int APICLIENT_TIMEOUT = -1007;
        public static final int CALL_EXCEPTION = -1008;
        public static final int EMPTY_PARAM = -1009;
    }
}

