/*
 * Decompiled with CFR 0.152.
 */
package com.heliandoctor.app.push.huawei;

import android.app.NotificationManager;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.heliandoctor.app.push.util.SendBroadcastUtil;
import com.huawei.hms.support.api.push.PushReceiver;
import java.util.ArrayList;
import java.util.List;

public class HuaweiPushRevicer
extends PushReceiver {
    public static final String TAG = "HuaweiPushRevicer";
    public static final String ACTION_UPDATEUI = "action.updateUI";
    public static final String ACTION_TOKEN = "action.updateToken";
    private static List<IPushCallback> pushCallbacks = new ArrayList<IPushCallback>();
    private static final Object CALLBACK_LOCK = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerPushCallback(IPushCallback callback) {
        Object object = CALLBACK_LOCK;
        synchronized (object) {
            pushCallbacks.add(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unRegisterPushCallback(IPushCallback callback) {
        Object object = CALLBACK_LOCK;
        synchronized (object) {
            pushCallbacks.remove(callback);
        }
    }

    public void onToken(Context context, String tokenIn, Bundle extras) {
        SendBroadcastUtil.sendPushId(context, tokenIn);
    }

    public boolean onPushMsg(Context context, byte[] msg, Bundle bundle) {
        try {
            String content = new String(msg, "UTF-8");
            SendBroadcastUtil.sendPassThroughEvent(context, "", content);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void onEvent(Context context, PushReceiver.Event event, Bundle extras) {
        int notifyId = 0;
        if ((PushReceiver.Event.NOTIFICATION_OPENED.equals((Object)event) || PushReceiver.Event.NOTIFICATION_CLICK_BTN.equals((Object)event)) && 0 != (notifyId = extras.getInt("pushNotifyId", 0))) {
            NotificationManager manager = (NotificationManager)context.getSystemService("notification");
            manager.cancel(notifyId);
        }
    }

    public void onPushState(Context context, boolean pushState) {
        Intent intent = new Intent();
        intent.setAction(ACTION_UPDATEUI);
        intent.putExtra("log", "The Push connection status is:" + pushState);
        HuaweiPushRevicer.callBack(intent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void callBack(Intent intent) {
        Object object = CALLBACK_LOCK;
        synchronized (object) {
            for (IPushCallback callback : pushCallbacks) {
                if (callback == null) continue;
                callback.onReceive(intent);
            }
        }
    }

    public static interface IPushCallback {
        public void onReceive(Intent var1);
    }
}

