/*
 * Decompiled with CFR 0.152.
 */
package com.heliandoctor.app.push.huawei;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.heliandoctor.app.push.PushInitContract;
import com.heliandoctor.app.push.huawei.api.HMSAgent;
import com.heliandoctor.app.push.huawei.api.common.handler.ConnectHandler;
import com.heliandoctor.app.push.huawei.api.push.handler.GetTokenHandler;
import com.heliandoctor.app.push.util.DeviceInfoUtil;
import com.heliandoctor.app.push.util.MetaDataUtil;

public class HuaweiPushInitializer
implements PushInitContract {
    private Application mApplication;

    public HuaweiPushInitializer(Application context) {
        this.mApplication = context;
    }

    @Override
    public void init() {
        HMSAgent.init(this.mApplication);
        HMSAgent.Push.getToken(new GetTokenHandler(){

            @Override
            public void onResult(int rst) {
            }
        });
        this.log();
    }

    @Override
    public boolean checkEnable() {
        if (DeviceInfoUtil.isHuawei() && !TextUtils.isEmpty((CharSequence)MetaDataUtil.getMetaDataValue((Context)this.mApplication, "com.huawei.hms.client.appid"))) {
            return true;
        }
        this.log();
        return false;
    }

    private void log() {
        if (TextUtils.isEmpty((CharSequence)MetaDataUtil.getMetaDataValue((Context)this.mApplication, "com.huawei.hms.client.appid"))) {
            Log.e((String)"pushConfigParams", (String)"default huawei push appId in AndroidManifest meta-data label");
        }
    }

    public static void connectHuaweiPush(Activity activity) {
        if (DeviceInfoUtil.isHuawei()) {
            HMSAgent.connect(activity, new ConnectHandler(){

                @Override
                public void onConnect(int rst) {
                    HMSAgent.Push.getToken(new GetTokenHandler(){

                        @Override
                        public void onResult(int rst) {
                            Log.d((String)"huaweiPushConnect", (String)(rst + ""));
                        }
                    });
                }
            });
        }
    }
}

