/*
 * Decompiled with CFR 0.152.
 */
package com.heliandoctor.app.push;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;

public abstract class CommonPushReceiver
extends BroadcastReceiver {
    protected Context mContext;

    public void onReceive(Context context, Intent intent) {
        this.mContext = context;
        int eventType = intent.getIntExtra("push_event_type", -1);
        switch (eventType) {
            case 0: {
                String pushId = intent.getStringExtra("push_id_key");
                this.onGetPushId(pushId);
                break;
            }
            case 1: {
                String title = intent.getStringExtra("push_title");
                String routeJson = intent.getStringExtra("push_route_info");
                this.onPushMsgArrived(title, routeJson);
                break;
            }
            case 2: {
                String title1 = intent.getStringExtra("push_title");
                String routeJson1 = intent.getStringExtra("push_route_info");
                this.onPushClicked(title1, routeJson1);
                break;
            }
            case 4: {
                String title2 = intent.getStringExtra("push_title");
                String message = intent.getStringExtra("push_through_info");
                this.onPushThrough(title2, message);
                break;
            }
        }
    }

    public abstract void onGetPushId(String var1);

    public abstract void onPushMsgArrived(String var1, String var2);

    public abstract void onPushClicked(String var1, String var2);

    public abstract void onPushThrough(String var1, String var2);
}

