package com.heliandoctor.app.push.xiaomi;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Process;
import android.text.TextUtils;
import android.util.Log;

import com.heliandoctor.app.push.PushInitContract;
import com.heliandoctor.app.push.util.DeviceInfoUtil;
import com.xiaomi.mipush.sdk.MiPushClient;

import java.util.List;

/**
 * 类描述：
 * 创建时间：2019/1/9
 *
 * @author chaochao
 */
public class XiaomiPushInitializer implements PushInitContract {

    private Context mContext;
    private String mAppId;
    private String mAppKey;

    public XiaomiPushInitializer(Context context, String appId, String appKey) {
        mContext = context;
        mAppId = appId;
        mAppKey = appKey;
    }

    @Override
    public void init() {
        // 注册push服务，注册成功后会向DemoMessageReceiver发送广播
        // 可以从DemoMessageReceiver的onCommandResult方法中MiPushCommandMessage对象参数中获取注册信息
        if (xiaomiShouldInit() && !TextUtils.isEmpty(mAppId) && !TextUtils.isEmpty(mAppKey)) {
            MiPushClient.registerPush(mContext, mAppId, mAppKey);
        }
        log();
    }

    @Override
    public boolean checkEnable() {
        if (DeviceInfoUtil.isXiaomi() && !TextUtils.isEmpty(mAppId) && !TextUtils.isEmpty(mAppKey)) {
            return true;
        }
        log();
        return false;
    }

    private void log() {
        if (TextUtils.isEmpty(mAppId)) {
            Log.e("pushConfigParams","default xiaomi push appId");
        }
        if (TextUtils.isEmpty(mAppKey)) {
            Log.e("pushConfigParams","default xiaomi push appKey");
        }
    }

    private boolean xiaomiShouldInit() {
        ActivityManager am = ((ActivityManager) mContext.getSystemService(Context.ACTIVITY_SERVICE));
        List<ActivityManager.RunningAppProcessInfo> processInfos = am.getRunningAppProcesses();
        String mainProcessName = mContext.getPackageName();
        int myPid = Process.myPid();
        if (processInfos != null && processInfos.size() > 0) {
            for (ActivityManager.RunningAppProcessInfo info : processInfos) {
                if (info.pid == myPid && mainProcessName.equals(info.processName)) {
                    return true;
                }
            }
        }

        return false;
    }
}
