package com.heliandoctor.app.push.util;

import android.content.Context;
import android.content.Intent;

import com.heliandoctor.app.push.PushConstants;

/**
 * 类描述：
 * 创建时间：2019/1/8
 *
 * @author chaochao
 */
public class SendBroadcastUtil {
    /**
     * pushId
     */
    public static void sendPushId(Context context,String pushId) {
        Intent intent = new Intent(PushConstants.PUSH_REGISTER_SUCCESS_ACTION);
        intent.setPackage(context.getPackageName());
        intent.putExtra(PushConstants.KEY_PUSH_ID,pushId);
        intent.putExtra(PushConstants.KEY_PUSH_EVENT_TYPE,PushConstants.PUSH_EVENT_TYPE_PUSH_ID);
        context.sendBroadcast(intent);
    }
    /**
     * 通知栏消息点击，附带信息
     */
    public static void sendPushClickEvent(Context context,String routeJson,String title) {
        Intent intent = new Intent(PushConstants.PUSH_REGISTER_SUCCESS_ACTION);
        intent.setPackage(context.getPackageName());
        intent.putExtra(PushConstants.KEY_PUSH_ROUTE_INFO,routeJson);
        intent.putExtra(PushConstants.KEY_PUSH_TITLE,title);
        intent.putExtra(PushConstants.KEY_PUSH_EVENT_TYPE,PushConstants.PUSH_EVENT_TYPE_PUSH_CLICK);
        context.sendBroadcast(intent);
    }

    /**
     * 通知栏消息到达，附带信息
     */
    public static void sendPushArrivedEvent(Context context,String routeJson,String title) {
        Intent intent = new Intent(PushConstants.PUSH_REGISTER_SUCCESS_ACTION);
        intent.setPackage(context.getPackageName());
        intent.putExtra(PushConstants.KEY_PUSH_ROUTE_INFO,routeJson);
        intent.putExtra(PushConstants.KEY_PUSH_TITLE,title);
        intent.putExtra(PushConstants.KEY_PUSH_EVENT_TYPE,PushConstants.PUSH_EVENT_TYPE_PUSH_ARRIVED);
        context.sendBroadcast(intent);
    }

    /**
     * 透传消息
     */
    public static void sendPassThroughEvent(Context context,String message,String title) {
        Intent intent = new Intent(PushConstants.PUSH_REGISTER_SUCCESS_ACTION);
        intent.setPackage(context.getPackageName());
        intent.putExtra(PushConstants.KEY_PUSH_THROUGH_INFO,message);
        intent.putExtra(PushConstants.KEY_PUSH_TITLE,title);
        intent.putExtra(PushConstants.KEY_PUSH_EVENT_TYPE,PushConstants.PUSH_EVENT_TYPE_PUSH_THROUGH);
        context.sendBroadcast(intent);
    }
}
