package com.heliandoctor.app.push.oppo;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;

import com.coloros.mcssdk.PushManager;
import com.coloros.mcssdk.mode.ErrorCode;
import com.heliandoctor.app.push.PushInitContract;
import com.heliandoctor.app.push.util.DeviceInfoUtil;
import com.heliandoctor.app.push.util.SendBroadcastUtil;

/**
 * 类描述：
 * 创建时间：2019/1/9
 *
 * @author chaochao
 */
public class OppoPushInitializer implements PushInitContract {

    private final Context mContext;
    private final String mAppKey;
    private final String mAppSecret;

    public OppoPushInitializer(Context context, String appKey, String appSecret) {
        mContext = context;
        mAppKey = appKey;
        mAppSecret = appSecret;
    }

    @Override
    public void init() {
        try {
            initOppo();
            log();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean checkEnable() {
        if (DeviceInfoUtil.isOppo() && !TextUtils.isEmpty(mAppKey) && !TextUtils.isEmpty(mAppSecret)) {
            return true;
        }
        log();
        return false;
    }

    private void log() {
        if (TextUtils.isEmpty(mAppKey)) {
            Log.e("pushConfigParams","default oppo push appKey");
        }
        if (TextUtils.isEmpty(mAppSecret)) {
            Log.e("pushConfigParams","default oppo push appSecret");
        }
    }

    private void initOppo() {
        if (!PushManager.isSupportPush(mContext) || TextUtils.isEmpty(mAppKey) || TextUtils.isEmpty(mAppSecret)) {
            return;
        }
        PushManager.getInstance().register(mContext, mAppKey, mAppSecret, new PushCallbackOnRegister() {
            @Override
            public void onRegister(int i, String s) {
                if (ErrorCode.SUCCESS == i) {
                    Log.v("oppoPushId", s);
                    SendBroadcastUtil.sendPushId(mContext,s);
                } else {//失败后，重新注册
                    PushManager.getInstance().getRegister();
                }
            }
        });

    }
}
