package com.heliandoctor.app.push.huawei;

import android.app.Activity;
import android.app.Application;
import android.text.TextUtils;
import android.util.Log;

import com.heliandoctor.app.push.PushConstants;
import com.heliandoctor.app.push.PushInitContract;
import com.heliandoctor.app.push.huawei.api.HMSAgent;
import com.heliandoctor.app.push.huawei.api.common.handler.ConnectHandler;
import com.heliandoctor.app.push.huawei.api.push.handler.GetTokenHandler;
import com.heliandoctor.app.push.util.DeviceInfoUtil;
import com.heliandoctor.app.push.util.MetaDataUtil;

/**
 * 类描述：
 * 创建时间：2019/1/9
 *
 * @author chaochao
 */
public class HuaweiPushInitializer implements PushInitContract {

    private Application mApplication;

    public HuaweiPushInitializer(Application context) {
        mApplication = context;
    }

    @Override
    public void init() {
        HMSAgent.init(mApplication);
        //未知
        HMSAgent.Push.getToken(new GetTokenHandler() {
            @Override
            public void onResult(int rst) {

            }
        });
        log();
    }

    @Override
    public boolean checkEnable() {
        if (DeviceInfoUtil.isHuawei()
                && !TextUtils.isEmpty(MetaDataUtil.getMetaDataValue(mApplication, PushConstants.KEY_HUAWEI_APPID_META))) {
            return true;
        }
        log();
        return false;
    }

    private void log() {
        if (TextUtils.isEmpty(MetaDataUtil.getMetaDataValue(mApplication, PushConstants.KEY_HUAWEI_APPID_META))) {
            Log.e("pushConfigParams","default huawei push appId in AndroidManifest meta-data label");
        }
    }

    /**
     * 华为连接推送及获取token
     * @param activity
     */
    public static void connectHuaweiPush(Activity activity) {
        if (DeviceInfoUtil.isHuawei()) {
            HMSAgent.connect(activity, new ConnectHandler() {
                @Override
                public void onConnect(int rst) {
                    HMSAgent.Push.getToken(new GetTokenHandler() {
                        @Override
                        public void onResult(int rst) {
                            Log.d("huaweiPushConnect", rst + "");
                        }
                    });
                }
            });
        }
    }
}
