package com.heliandoctor.app.push;

import android.support.annotation.NonNull;

import java.util.List;

/**
 * 类描述：多种推送sdk初始化
 * 创建时间：2018/10/11
 *
 * @author chaochao
 */
public class MultiPushInitializer {

    public static void setInitializers(List<PushInitContract> initializers,@NonNull PushInitContract defaultInitContract) {
        boolean hasInit =false;
        if (initializers != null && initializers.size() > 0) {
            for (int i = 0; i < initializers.size(); i++) {
                PushInitContract pushInitContract = initializers.get(i);
                if (pushInitContract.checkEnable()) {
                    pushInitContract.init();
                    hasInit = true;
                    break;
                }
            }
        }

        if (!hasInit) {
            if (defaultInitContract != null) {
                defaultInitContract.init();
            }
        }
    }
}
