package com.heliandoctor.app.push;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;

/**
 * 类描述：
 * 创建时间：2019/1/8
 *
 * @author chaochao
 */
public abstract class CommonPushReceiver extends BroadcastReceiver {
    protected Context mContext;

    @Override
    public void onReceive(Context context, Intent intent) {
        mContext = context;

        int eventType = intent.getIntExtra(PushConstants.KEY_PUSH_EVENT_TYPE, -1);
        switch (eventType) {
            case PushConstants.PUSH_EVENT_TYPE_PUSH_ID:
                String pushId = intent.getStringExtra(PushConstants.KEY_PUSH_ID);
                onGetPushId(pushId);
                break;
            case PushConstants.PUSH_EVENT_TYPE_PUSH_ARRIVED:
                String title = intent.getStringExtra(PushConstants.KEY_PUSH_TITLE);
                String routeJson = intent.getStringExtra(PushConstants.KEY_PUSH_ROUTE_INFO);
                onPushMsgArrived(title,routeJson);
                break;
            case PushConstants.PUSH_EVENT_TYPE_PUSH_CLICK:
                String title1 = intent.getStringExtra(PushConstants.KEY_PUSH_TITLE);
                String routeJson1 = intent.getStringExtra(PushConstants.KEY_PUSH_ROUTE_INFO);
                onPushClicked(title1,routeJson1);
                break;
            case PushConstants.PUSH_EVENT_TYPE_PUSH_THROUGH:
                String title2 = intent.getStringExtra(PushConstants.KEY_PUSH_TITLE);
                String message = intent.getStringExtra(PushConstants.KEY_PUSH_THROUGH_INFO);
                onPushThrough(title2,message);
                break;
            default:
        }
    }

    public abstract void onGetPushId(String pushId);
    public abstract void onPushMsgArrived(String title,String data);
    public abstract void onPushClicked(String title,String data);
    public abstract void onPushThrough(String title,String data);

}
