/*
 * Decompiled with CFR 0.152.
 */
package com.helian.app.download;

import android.app.DownloadManager;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import com.helian.app.download.DownloadListener;
import com.helian.app.download.PermissionCheck;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class DownloadHelper {
    private static DownloadHelper mDownloadHelper;
    private String mDir;
    private DownloadManager mDownloadManager;
    private Map<Long, DownloadListener> mDownloadMap = new HashMap<Long, DownloadListener>();

    public static DownloadHelper getInstance() {
        if (mDownloadHelper == null) {
            mDownloadHelper = new DownloadHelper();
        }
        return mDownloadHelper;
    }

    public void init(String dir) {
        this.mDir = dir;
    }

    public void download(Context context, String path, String fileName, DownloadListener listener) {
        this.download(context, path, this.mDir, fileName, listener);
    }

    public void download(Context context, String path, String dir, String fileName, DownloadListener listener) {
        if (!PermissionCheck.check(context)) {
            return;
        }
        this.mDownloadManager = (DownloadManager)context.getSystemService("download");
        Uri uri = Uri.parse((String)path);
        DownloadManager.Request request = new DownloadManager.Request(uri);
        request.setDestinationInExternalPublicDir(dir, fileName);
        request.setVisibleInDownloadsUi(false);
        request.setNotificationVisibility(2);
        long downloadId = this.mDownloadManager.enqueue(request);
        this.mDownloadMap.put(downloadId, listener);
        this.downloadListener(downloadId);
    }

    private void downloadListener(final long downloadId) {
        final ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(3);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                boolean isComplete = DownloadHelper.this.updateView(downloadId);
                if (isComplete) {
                    scheduledExecutorService.shutdown();
                }
            }
        };
        scheduledExecutorService.scheduleAtFixedRate(runnable, 0L, 1L, TimeUnit.SECONDS);
    }

    public boolean updateView(long downloadId) {
        int[] bytesAndStatus = this.getBytesAndStatus(downloadId);
        int currentSize = bytesAndStatus[0];
        int totalSize = bytesAndStatus[1];
        int status = bytesAndStatus[2];
        boolean isComplete = false;
        DownloadListener downloadListener = this.mDownloadMap.get(downloadId);
        if (downloadListener != null) {
            if (status != 8) {
                downloadListener.progress((int)((float)currentSize / (float)totalSize * 100.0f));
            } else {
                downloadListener.complete();
                isComplete = true;
            }
        }
        return isComplete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getBytesAndStatus(long downloadId) {
        int[] bytesAndStatus = new int[]{-1, -1, 0};
        DownloadManager.Query query = new DownloadManager.Query().setFilterById(new long[]{downloadId});
        try (Cursor c = null;){
            c = this.mDownloadManager.query(query);
            if (c != null && c.moveToFirst()) {
                bytesAndStatus[0] = c.getInt(c.getColumnIndexOrThrow("bytes_so_far"));
                bytesAndStatus[1] = c.getInt(c.getColumnIndexOrThrow("total_size"));
                bytesAndStatus[2] = c.getInt(c.getColumnIndex("status"));
            }
        }
        return bytesAndStatus;
    }
}

