/*
 * Decompiled with CFR 0.152.
 */
package com.helian.app.deviceid;

import android.content.Context;
import android.os.Environment;
import android.support.v4.app.ActivityCompat;
import android.text.TextUtils;
import com.helian.app.api.Api;
import com.helian.app.deviceid.FileUtil;
import com.helian.app.deviceid.ImeiUtil;
import com.helian.app.deviceid.ImsiUtil;
import com.helian.app.deviceid.MacUtil;
import com.helian.app.deviceid.api.DeviceService;
import com.helian.app.deviceid.api.bean.DeviceIdBean;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class DeviceIdManager {
    private static final String PATH = Environment.getExternalStorageDirectory().toString() + File.separator + "com.helian.device";
    private static final String FILE_NAME = "device.txt";
    private static final String MAC_KEY = "mac";
    private static final String IMSI_KEY = "imsi";
    private static final String IMEI_KEY = "imei";
    private static final String DEVICE_ID_KEY = "device_id";
    private static DeviceIdManager mDeviceIdManager;
    private Context mContext;
    private Api mApi;
    private File mFile;
    private String mDeviceId;
    private boolean mIsDebug;
    private boolean mIsSync;

    public static DeviceIdManager getInstance() {
        if (mDeviceIdManager == null) {
            mDeviceIdManager = new DeviceIdManager();
        }
        return mDeviceIdManager;
    }

    public void setDebug(boolean isDebug) {
        this.mIsDebug = isDebug;
    }

    private String getBaseUrl() {
        return "http://usergateway.helianhealth.com/api/";
    }

    private void init() {
        this.init(this.mContext);
    }

    public void init(Context context) {
        this.mContext = context.getApplicationContext();
        this.initFile(context);
        if (!TextUtils.isEmpty((CharSequence)this.mDeviceId) || this.mIsSync) {
            return;
        }
        String mac = MacUtil.getMac(context);
        String imei = ImeiUtil.getImei(context);
        String imsi = ImsiUtil.getImsi(context);
        String deviceId = this.getRandomDeviceId();
        if (this.mFile.exists()) {
            String json = FileUtil.read(this.mFile.getAbsolutePath());
            if (!TextUtils.isEmpty((CharSequence)json)) {
                try {
                    JSONObject jsonObject = new JSONObject(json);
                    if (jsonObject.has(MAC_KEY) && TextUtils.isEmpty((CharSequence)mac)) {
                        mac = jsonObject.getString(MAC_KEY);
                    }
                    if (jsonObject.has(IMEI_KEY) && TextUtils.isEmpty((CharSequence)imei)) {
                        imei = jsonObject.getString(IMEI_KEY);
                    }
                    if (jsonObject.has(IMSI_KEY) && TextUtils.isEmpty((CharSequence)imsi)) {
                        imsi = jsonObject.getString(IMSI_KEY);
                    }
                    if (jsonObject.has(DEVICE_ID_KEY)) {
                        deviceId = jsonObject.getString(DEVICE_ID_KEY);
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        } else {
            this.write(deviceId, mac, imei, imsi, this.mFile);
        }
        if (this.mApi == null) {
            this.mApi = Api.getInitialize().init(this.getBaseUrl(), 0, 15, false).build();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("dvc_id", deviceId);
        map.put("os", "1");
        if (TextUtils.isEmpty((CharSequence)imei)) {
            imei = "";
        }
        map.put(IMEI_KEY, imei);
        if (TextUtils.isEmpty((CharSequence)imsi)) {
            imsi = "";
        }
        map.put(IMSI_KEY, imsi);
        if (TextUtils.isEmpty((CharSequence)mac)) {
            mac = "";
        }
        map.put(MAC_KEY, mac);
        final String finalImsi = imsi;
        final String finalMac = mac;
        final String finalImei = imei;
        this.mIsSync = true;
        ((DeviceService)this.mApi.getService(DeviceService.class)).syncDevice(map).enqueue((Callback)new Callback<DeviceIdBean>(){

            public void onResponse(Call<DeviceIdBean> call, Response<DeviceIdBean> response) {
                DeviceIdManager.this.mIsSync = false;
                try {
                    DeviceIdBean bean = (DeviceIdBean)response.body();
                    if (bean == null || !"10000".equals(bean.getCode())) {
                        return;
                    }
                    DeviceIdManager.this.mDeviceId = bean.getBizContent();
                    DeviceIdManager.this.write(DeviceIdManager.this.mDeviceId, finalMac, finalImei, finalImsi, DeviceIdManager.this.mFile);
                }
                catch (Exception e) {
                    e.fillInStackTrace();
                }
            }

            public void onFailure(Call<DeviceIdBean> call, Throwable t) {
                DeviceIdManager.this.mIsSync = false;
                t.fillInStackTrace();
            }
        });
    }

    private void initFile(Context context) {
        if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_EXTERNAL_STORAGE") != 0 || ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
            this.mFile = this.getFile(context.getCacheDir().getAbsolutePath());
        } else {
            File cacheFile;
            this.mFile = this.getFile(PATH);
            if (!this.mFile.exists() && (cacheFile = new File(context.getCacheDir(), FILE_NAME)).exists()) {
                try {
                    FileUtil.copy(cacheFile, this.mFile);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private File getFile(String path) {
        if (this.mFile != null && this.mFile.getAbsolutePath().contains(path)) {
            return this.mFile;
        }
        return new File(path, FILE_NAME);
    }

    public String getDeviceId() {
        String deviceId = null;
        if (TextUtils.isEmpty((CharSequence)this.mDeviceId)) {
            String json;
            this.init();
            if (this.mFile.exists() && !TextUtils.isEmpty((CharSequence)(json = FileUtil.read(this.mFile.getAbsolutePath())))) {
                try {
                    JSONObject jsonObject = new JSONObject(json);
                    if (jsonObject.has(DEVICE_ID_KEY)) {
                        deviceId = jsonObject.getString(DEVICE_ID_KEY);
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            if (TextUtils.isEmpty((CharSequence)deviceId)) {
                deviceId = this.getRandomDeviceId();
                this.write(deviceId, null, null, null, this.mFile);
            }
        } else {
            deviceId = this.mDeviceId;
        }
        return deviceId;
    }

    private String getRandomDeviceId() {
        return "L_A_" + UUID.randomUUID().toString().toUpperCase();
    }

    private void write(String deviceId, String mac, String imei, String imsi, File file) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put(DEVICE_ID_KEY, (Object)deviceId);
            jsonObject.put(MAC_KEY, (Object)mac);
            jsonObject.put(IMEI_KEY, (Object)imei);
            jsonObject.put(IMSI_KEY, (Object)imsi);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        FileUtil.write(file.getAbsolutePath(), jsonObject.toString());
    }
}

