package com.helian.app.deviceid;

import android.content.Context;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.text.TextUtils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.NetworkInterface;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MacUtil {

    public static String getMac(Context context) {
        String mac = null;
        if (Build.VERSION.SDK_INT <= Build.VERSION_CODES.LOLLIPOP_MR1) {
            mac = getMacLollipop(context);
        }
        else if (Build.VERSION.SDK_INT == Build.VERSION_CODES.M) {
            mac = getMacM();
        }
        else {
            mac = getMacUpward();
        }

        if (TextUtils.isEmpty(mac)) {
            return null;
        }
        mac = mac.toLowerCase();
        if (!TextUtils.isEmpty(mac) && mac.indexOf("-") != -1) {
            mac = mac.replaceAll("-", ":");
        }
        boolean isMatch = Pattern.matches("[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}", mac);
        if (isMatch
                && !"00:00:00:00:00:00".equals(mac)
                && !"02:00:00:00:00:00".equals(mac)
                && !"ff:ff:ff:ff:ff:ff".equals(mac)) {
            return mac;
        }
        else {
            return null;
        }
    }

    private static String getMacLollipop(Context context) {
        String mac = null;
        if (context == null) {
            return mac;
        }

        WifiManager wifi = (WifiManager) context.getApplicationContext()
                .getSystemService(Context.WIFI_SERVICE);
        if (wifi == null) {
            return mac;
        }
        WifiInfo info = null;
        try {
            info = wifi.getConnectionInfo();
        } catch (Exception e) {
        }
        if (info == null) {
            return null;
        }
        mac = info.getMacAddress();
        if (!TextUtils.isEmpty(mac)) {
            mac = mac.toUpperCase(Locale.ENGLISH);
        }
        return mac;
    }

    private static String getMacM() {
        String wifiAddress = null;
        try {
            wifiAddress = new BufferedReader(new FileReader(new File("/sys/class/net/wlan0/address"))).readLine();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return wifiAddress;
    }

    private static String getMacUpward() {
        try {
            List<NetworkInterface> all = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface nif : all) {
                if (!nif.getName().equalsIgnoreCase("wlan0")) continue;

                byte[] macBytes = nif.getHardwareAddress();
                if (macBytes == null) {
                    return "";
                }

                StringBuilder res1 = new StringBuilder();
                for (byte b : macBytes) {
                    res1.append(String.format("%02X:", b));
                }

                if (res1.length() > 0) {
                    res1.deleteCharAt(res1.length() - 1);
                }
                return res1.toString();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

}
