/*
 * Decompiled with CFR 0.152.
 */
package com.helian.app.deviceid;

import android.content.Context;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.text.TextUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.regex.Pattern;

public class MacUtil {
    public static String getMac(Context context) {
        boolean isMatch;
        String mac = null;
        mac = Build.VERSION.SDK_INT <= 22 ? MacUtil.getMacLollipop(context) : (Build.VERSION.SDK_INT == 23 ? MacUtil.getMacM() : MacUtil.getMacUpward());
        if (TextUtils.isEmpty((CharSequence)mac)) {
            return null;
        }
        if (!TextUtils.isEmpty((CharSequence)(mac = mac.toLowerCase())) && mac.indexOf("-") != -1) {
            mac = mac.replaceAll("-", ":");
        }
        if ((isMatch = Pattern.matches("[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}", mac)) && !"00:00:00:00:00:00".equals(mac) && !"02:00:00:00:00:00".equals(mac) && !"ff:ff:ff:ff:ff:ff".equals(mac)) {
            return mac;
        }
        return null;
    }

    private static String getMacLollipop(Context context) {
        String mac = null;
        if (context == null) {
            return mac;
        }
        WifiManager wifi = (WifiManager)context.getApplicationContext().getSystemService("wifi");
        if (wifi == null) {
            return mac;
        }
        WifiInfo info = null;
        try {
            info = wifi.getConnectionInfo();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (info == null) {
            return null;
        }
        mac = info.getMacAddress();
        if (!TextUtils.isEmpty((CharSequence)mac)) {
            mac = mac.toUpperCase(Locale.ENGLISH);
        }
        return mac;
    }

    private static String getMacM() {
        String wifiAddress = null;
        try {
            wifiAddress = new BufferedReader(new FileReader(new File("/sys/class/net/wlan0/address"))).readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return wifiAddress;
    }

    private static String getMacUpward() {
        try {
            ArrayList<NetworkInterface> all = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface nif : all) {
                if (!nif.getName().equalsIgnoreCase("wlan0")) continue;
                byte[] macBytes = nif.getHardwareAddress();
                if (macBytes == null) {
                    return "";
                }
                StringBuilder res1 = new StringBuilder();
                for (byte b : macBytes) {
                    res1.append(String.format("%02X:", b));
                }
                if (res1.length() > 0) {
                    res1.deleteCharAt(res1.length() - 1);
                }
                return res1.toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

