package com.helian.app.deviceid;

import android.Manifest;
import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageManager;
import android.support.v4.app.ActivityCompat;
import android.telephony.TelephonyManager;
import android.text.TextUtils;

import java.util.regex.Pattern;

public class ImsiUtil {

    public static String getImsi(Context context) {
        String imsi = null;
        if (ActivityCompat.checkSelfPermission(context, Manifest.permission.READ_PHONE_STATE) != PackageManager.PERMISSION_GRANTED) {
            return null;
        }
        TelephonyManager manager = (TelephonyManager) context.getSystemService(Activity.TELEPHONY_SERVICE);
        if (manager != null) {
            imsi = manager.getSubscriberId();
        }
        if (TextUtils.isEmpty(imsi)) {
            return null;
        }
        boolean isMatch = imsi.length() == 15 && Pattern.matches("^[0" +
                        "-9]*$",
                imsi);

        if (isMatch && !"000000000000000".equals(imsi)) {
            return imsi;
        }
        return null;
    }
}
