package com.helian.app.deviceid;

import android.Manifest;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Environment;
import android.support.v4.app.ActivityCompat;
import android.text.TextUtils;
import android.widget.Toast;

import com.helian.app.api.Api;
import com.helian.app.deviceid.api.DeviceService;
import com.helian.app.deviceid.api.bean.DeviceIdBean;

import org.json.JSONException;
import org.json.JSONObject;
import java.io.File;
import java.util.HashMap;
import java.util.UUID;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class DeviceIdManager {

    private static final String PATH = Environment.getExternalStorageDirectory().toString() + File.separator + "com.helian.device";
    private static final String FILE_NAME = "device.txt";
    private static final String MAC_KEY = "mac";
    private static final String IMSI_KEY = "imsi";
    private static final String IMEI_KEY = "imei";
    private static final String DEVICE_ID_KEY = "device_id";

    private static DeviceIdManager mDeviceIdManager;
    private Context mContext;
    private Api mApi;
    private File mFile;
    private boolean mIsDebug;

    public static DeviceIdManager getInstance() {
        if (mDeviceIdManager == null) {
            mDeviceIdManager = new DeviceIdManager();
        }
        return mDeviceIdManager;
    }

    public void setDebug(boolean isDebug) {
        mIsDebug = isDebug;
    }

    private String getBaseUrl() {
        if (mIsDebug) {
            return "http://usercentretest.hz.taeapp.com/api/";
        }
        else {
            return "https://doctor.helianhealth.com/api/";
        }
    }

    public void init(final Context context) {
        mContext = context.getApplicationContext();
        initFile(context);

        String mac = MacUtil.getMac(context);
        String imei = ImeiUtil.getImei(context);
        String imsi = ImsiUtil.getImsi(context);
        String deviceId = getRandomDeviceId();
        if (mFile.exists()) {
            String json = FileUtil.read(mFile.getAbsolutePath());
            if (!TextUtils.isEmpty(json)) {
                try {
                    JSONObject jsonObject = new JSONObject(json);
                    if (jsonObject.has(MAC_KEY) && TextUtils.isEmpty(mac)) {
                        mac = jsonObject.getString(MAC_KEY);
                    }
                    if (jsonObject.has(IMEI_KEY) && TextUtils.isEmpty(imei)) {
                        imei = jsonObject.getString(IMEI_KEY);
                    }
                    if (jsonObject.has(IMSI_KEY) && TextUtils.isEmpty(imsi)) {
                        imsi = jsonObject.getString(IMSI_KEY);
                    }
                    if (jsonObject.has(DEVICE_ID_KEY)) {
                        deviceId = jsonObject.getString(DEVICE_ID_KEY);
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
        else {
            write(deviceId, mac, imei, imsi, mFile);
        }

        if (mApi == null) {
            mApi = Api.getInitialize()
                    .init(getBaseUrl(),     0, 15, false)
                    .build();
        }

        HashMap<String, String> map = new HashMap<>();
        map.put("dvc_id", deviceId);
        map.put("os", "1");
        if (TextUtils.isEmpty(imei)) {
            imei = "";
        }
        map.put("imei", imei);
        if (TextUtils.isEmpty(imsi)) {
            imsi = "";
        }
        map.put("imsi", imsi);
        if (TextUtils.isEmpty(mac)) {
            mac = "";
        }
        map.put("mac", mac);
        final String finalImsi = imsi;
        final String finalMac = mac;
        final String finalImei = imei;
        mApi.getService(DeviceService.class).syncDevice(map).enqueue(new Callback<DeviceIdBean>() {
            @Override
            public void onResponse(Call<DeviceIdBean> call, Response<DeviceIdBean> response) {
                try {
                    DeviceIdBean bean = response.body();
                    if (bean == null || !"10000".equals(bean.getCode())) {
                        Toast.makeText(context, bean == null ? "bean is null" : bean.toString(), Toast.LENGTH_SHORT).show();
                        return;
                    }

                    write(bean.getBizContent(), finalMac, finalImei, finalImsi, mFile);
                } catch (Exception e) {
                    e.fillInStackTrace();
                }
            }

            @Override
            public void onFailure(Call<DeviceIdBean> call, Throwable t) {
                t.fillInStackTrace();
            }
        });
    }

    private void initFile(Context context) {
        if (ActivityCompat.checkSelfPermission(context, Manifest.permission.READ_EXTERNAL_STORAGE)
                != PackageManager.PERMISSION_GRANTED
                || ActivityCompat.checkSelfPermission(context, Manifest.permission.WRITE_EXTERNAL_STORAGE)
                != PackageManager.PERMISSION_GRANTED) {
            mFile = new File(context.getCacheDir(), FILE_NAME);
        }
        else {
            mFile = new File(PATH, FILE_NAME);
        }
    }

    public String getDeviceId() {
        initFile(mContext);
        String deviceId = null;
        if (mFile.exists()) {
            String json = FileUtil.read(mFile.getAbsolutePath());
            if (!TextUtils.isEmpty(json)) {
                try {
                    JSONObject jsonObject = new JSONObject(json);
                    if (jsonObject.has(DEVICE_ID_KEY)) {
                        deviceId = jsonObject.getString(DEVICE_ID_KEY);
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }

        if (TextUtils.isEmpty(deviceId)) {
            deviceId = getRandomDeviceId();
            write(deviceId, null, null, null, mFile);
        }
        return deviceId;
    }

    private String getRandomDeviceId() {
        return "L_A_" + UUID.randomUUID().toString().toUpperCase();
    }

    private void write(String deviceId, String mac, String imei, String imsi, File file) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put(DEVICE_ID_KEY, deviceId);
            jsonObject.put(MAC_KEY, mac);
            jsonObject.put(IMEI_KEY, imei);
            jsonObject.put(IMSI_KEY, imsi);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        FileUtil.write(file.getAbsolutePath(), jsonObject.toString());
    }

}
