/*
 * Decompiled with CFR 0.152.
 */
package com.helian.app.api.interceptor;

import android.text.TextUtils;
import com.helian.app.api.bean.MultipleDNSInfo;
import java.io.IOException;
import java.util.List;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class UrlInterceptor
implements Interceptor {
    private MultipleDNSInfo mMultipleDNSInfo;

    public UrlInterceptor(MultipleDNSInfo multipleDNSInfo) {
        this.mMultipleDNSInfo = multipleDNSInfo;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Request.Builder builder = request.newBuilder();
        List headerValues = request.headers("url_key");
        if (headerValues != null && headerValues.size() > 0) {
            builder.removeHeader("url_key");
            String headerValue = (String)headerValues.get(0);
            if (this.mMultipleDNSInfo != null && this.mMultipleDNSInfo.getDNSMap() != null && this.mMultipleDNSInfo.getDNSMap().size() > 0) {
                String newPath;
                HttpUrl newBaseUrl = HttpUrl.parse((String)this.mMultipleDNSInfo.getDNSMap().get(headerValue));
                HttpUrl oldHttpUrl = request.url();
                String path = oldHttpUrl.encodedPath();
                if (!TextUtils.isEmpty((CharSequence)this.mMultipleDNSInfo.getFilter())) {
                    path = path.substring(path.indexOf(this.mMultipleDNSInfo.getFilter()) + this.mMultipleDNSInfo.getFilter().length());
                }
                if (!TextUtils.isEmpty((CharSequence)(newPath = newBaseUrl.encodedPath()))) {
                    path = newPath + path;
                }
                HttpUrl newFullUrl = oldHttpUrl.newBuilder().scheme(newBaseUrl.scheme()).host(newBaseUrl.host()).port(newBaseUrl.port()).encodedPath(path).build();
                return chain.proceed(builder.url(newFullUrl).build());
            }
        }
        return chain.proceed(request);
    }
}

