/*
 * Decompiled with CFR 0.152.
 */
package com.helian.app.api.interceptor;

import android.content.Context;
import com.helian.app.api.utils.NetWorkUtil;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class NetWorkCacheInterceptor
implements Interceptor {
    private Context mContext;
    private boolean mIsCache;

    public NetWorkCacheInterceptor(Context context, boolean isCache) {
        this.mContext = context;
        this.mIsCache = isCache;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Response response = chain.proceed(request);
        if (this.mIsCache) {
            if (NetWorkUtil.isAvailable(this.mContext).booleanValue()) {
                int maxAge = 0;
                response.newBuilder().removeHeader("Pragma").removeHeader("Cache-Control").header("Cache-Control", "public, max-age=" + maxAge).build();
            } else {
                int maxStale = 604800;
                response.newBuilder().header("Cache-Control", "public, only-if-cached, max-stale=" + maxStale).removeHeader("Pragma").build();
            }
        }
        return response;
    }
}

