/*
 * Decompiled with CFR 0.152.
 */
package com.helian.app.api;

import android.content.Context;
import com.helian.app.api.bean.MultipleDNSInfo;
import com.helian.app.api.interceptor.RetryInterceptor;
import com.helian.app.api.interceptor.UrlInterceptor;
import com.jakewharton.retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class Api {
    public static final String URL_KEY = "url_key";
    private static Api mApi;
    private static Context mContext;
    private static MultipleDNSInfo mMultipleDNSInfo;
    private static List<Interceptor> mInterceptorList;
    private Retrofit.Builder mBuilder;
    private Retrofit mRetrofit;

    public static void init(Context context) {
        mContext = context;
    }

    public static void initInterceptor(List<Interceptor> interceptorList) {
        mInterceptorList = interceptorList;
    }

    public static void initMultipleDNS(MultipleDNSInfo multipleDNSInfo) {
        mMultipleDNSInfo = multipleDNSInfo;
    }

    public static Api getInitialize() {
        if (mApi == null) {
            mApi = new Api();
        }
        return mApi;
    }

    private Api() {
    }

    public OkHttpClient addClient(int retryCount, int timeout, boolean isCache) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder().retryOnConnectionFailure(true).addInterceptor((Interceptor)new RetryInterceptor(retryCount)).addInterceptor((Interceptor)new UrlInterceptor(mMultipleDNSInfo)).connectTimeout((long)timeout, TimeUnit.SECONDS);
        if (mInterceptorList != null && mInterceptorList.size() > 0) {
            for (Interceptor interceptor : mInterceptorList) {
                builder.addInterceptor(interceptor);
            }
        }
        OkHttpClient client = builder.build();
        return client;
    }

    public Api init(String baseUrl) {
        return this.init(baseUrl, 1, 40);
    }

    public Api init(String baseUrl, int retryCount, int timeout) {
        return this.init(baseUrl, retryCount, timeout, false);
    }

    public Api init(String baseUrl, int retryCount, int timeout, boolean isCache) {
        this.mBuilder = new Retrofit.Builder().baseUrl(baseUrl).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create());
        this.mBuilder.client(this.addClient(retryCount, timeout, isCache));
        return this;
    }

    public Api build() {
        this.mRetrofit = this.mBuilder.build();
        return this;
    }

    public <T> T getService(Class<T> serviceClass) {
        return (T)this.mRetrofit.create(serviceClass);
    }
}

