package com.helian.app.api.interceptor;

import android.text.TextUtils;

import com.helian.app.api.Api;
import com.helian.app.api.bean.MultipleDNSInfo;

import java.io.IOException;
import java.util.List;

import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

/**
 * Created by Refluence on 2017/11/15.
 */

public class UrlInterceptor implements Interceptor {

    private MultipleDNSInfo mMultipleDNSInfo;

    public UrlInterceptor(MultipleDNSInfo multipleDNSInfo) {
        mMultipleDNSInfo = multipleDNSInfo;
    }

    @Override
    public Response intercept(Chain chain) throws IOException {
        Request request = chain.request();
        Request.Builder builder = request.newBuilder();
        List<String> headerValues = request.headers(Api.URL_KEY);
        if (headerValues != null && headerValues.size() > 0) {
            builder.removeHeader(Api.URL_KEY);

            String headerValue = headerValues.get(0);
            if (mMultipleDNSInfo != null) {
                if (mMultipleDNSInfo.getDNSMap() != null && mMultipleDNSInfo.getDNSMap().size() > 0) {
                    HttpUrl newBaseUrl = HttpUrl.parse(mMultipleDNSInfo.getDNSMap().get(headerValue));
                    HttpUrl oldHttpUrl = request.url();
                    String path = oldHttpUrl.encodedPath();
                    if (!TextUtils.isEmpty(mMultipleDNSInfo.getFilter())) {
                        path = path.substring(path.indexOf(mMultipleDNSInfo.getFilter())
                                + mMultipleDNSInfo.getFilter().length());
                    }

                    String newPath = newBaseUrl.encodedPath();
                    if (!TextUtils.isEmpty(newPath)) {
                        path = newPath + path;
                    }

                    HttpUrl newFullUrl = oldHttpUrl
                            .newBuilder()
                            .scheme(newBaseUrl.scheme())
                            .host(newBaseUrl.host())
                            .port(newBaseUrl.port())
                            .encodedPath(path)
                            .build();

                    return chain.proceed(builder.url(newFullUrl).build());
                }
            }
        }
        return chain.proceed(request);
    }
}
