package com.helian.app.api.interceptor;

import java.io.IOException;

import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

/**
 * Created by CC on 2017/4/9.
 */

public class RetryInterceptor implements Interceptor {
    private int mMaxRetry;
    private int retryNum = 0;

    public RetryInterceptor(int maxRetry) {
        mMaxRetry = maxRetry;
    }

    @Override
    public Response intercept(Chain chain) throws IOException {
        Request request = chain.request();
        Response response = chain.proceed(request);
        while (!response.isSuccessful() && retryNum < mMaxRetry) {
            retryNum++;
            response = chain.proceed(request);
        }
        return response;
    }

}
