package com.helian.app.api.interceptor;

import android.content.Context;

import com.helian.app.api.utils.NetWorkUtil;

import java.io.IOException;

import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

/**
 * Created by Refluence on 2017/5/14.
 */

public class NetWorkCacheInterceptor implements Interceptor {

    private Context mContext;
    private boolean mIsCache;
    public NetWorkCacheInterceptor(Context context, boolean isCache) {
        mContext = context;
        mIsCache = isCache;
    }

    @Override
    public Response intercept(Chain chain) throws IOException {
        Request request = chain.request();
        Response response = chain.proceed(request);
        if (mIsCache) {
            if (NetWorkUtil.isAvailable(mContext)) {
                int maxAge = 0 * 60;
                response.newBuilder()
                        .removeHeader("Pragma")
                        .removeHeader("Cache-Control")
                        .header("Cache-Control", "public, max-age=" + maxAge)
                        .build();
            }
            else {
                int maxStale = 60 * 60 * 24 * 7;
                response.newBuilder()
                        .header("Cache-Control", "public, only-if-cached, max-stale=" + maxStale)
                        .removeHeader("Pragma")
                        .build();
            }
        }
        return response;
    }
}
