package com.helian.app.api.interceptor;

import android.content.Context;


import com.helian.app.api.utils.NetWorkUtil;

import java.io.IOException;

import okhttp3.CacheControl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

/**
 * Created by Refluence on 2017/5/14.
 */

public class LocalCacheInterceptor implements Interceptor {
    private Context mContext;
    private boolean mIsCache;

    public LocalCacheInterceptor(Context context, boolean isCache) {
        mContext = context;
        mIsCache = isCache;
    }

    @Override
    public Response intercept(Chain chain) throws IOException {
        Request request = chain.request();
        if (!NetWorkUtil.isAvailable(mContext) && mIsCache) {
//            int maxStale = 60 * 60 * 24 * 28;
//            CacheControl tempCacheControl = new CacheControl.Builder()
//                    .onlyIfCached()
//                    .maxStale(maxStale, TimeUnit.SECONDS)
//                    .build();
//            request = request.newBuilder()
//                    .cacheControl(tempCacheControl)
//                    .build();
            request = request.newBuilder()
                    .cacheControl(CacheControl.FORCE_CACHE)
                    .build();
        }
        return chain.proceed(request);
    }

}
