package com.helian.app.api;

import android.content.Context;

import com.helian.app.api.bean.MultipleDNSInfo;
import com.helian.app.api.interceptor.RetryInterceptor;
import com.helian.app.api.interceptor.UrlInterceptor;
import com.jakewharton.retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;

import java.util.List;
import java.util.concurrent.TimeUnit;

import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

/**
 * Created by CC on 2017/2/9.
 */

public class Api {
    public static final String URL_KEY = "url_key";

    private static Api mApi;
    private static Context mContext;
    private static MultipleDNSInfo mMultipleDNSInfo;
    private static List<Interceptor> mInterceptorList;

    public static void init(Context context) {
        mContext = context;
    }

    public static void initInterceptor(List<Interceptor> interceptorList) {
        mInterceptorList = interceptorList;
    }

    public static void initMultipleDNS(MultipleDNSInfo multipleDNSInfo) {
        mMultipleDNSInfo = multipleDNSInfo;
    }

    public static Api getInitialize() {
        if (mApi == null) {
            mApi = new Api();
        }
        return mApi;
    }

    private Api() {}

    public OkHttpClient addClient(int retryCount, int timeout, boolean isCache) {
//        //外部存储
//        File httpCacheDirectory = new File(mContext.getCacheDir(), "ApiCache");
//        if (!httpCacheDirectory.exists())
//            httpCacheDirectory.mkdirs();
//        //设置缓存 10M
//        int cacheSize = 10 * 1024 * 1024;
//        Cache cache = new Cache(httpCacheDirectory, cacheSize);

        OkHttpClient.Builder builder = new OkHttpClient.Builder()
//                .cache(cache)
                .retryOnConnectionFailure(true)
                .addInterceptor(new RetryInterceptor(retryCount))
                .addInterceptor(new UrlInterceptor(mMultipleDNSInfo))
//                .addInterceptor(new LocalCacheInterceptor(mContext, isCache))
//                .addNetworkInterceptor(new NetWorkCacheInterceptor(mContext, isCache))
                .connectTimeout(timeout, TimeUnit.SECONDS);
        if (mInterceptorList != null && mInterceptorList.size() > 0) {
            for (Interceptor interceptor : mInterceptorList) {
                builder.addInterceptor(interceptor);
            }
        }

        OkHttpClient client = builder.build();
        return client;

//        OkHttpClient client = new OkHttpClient.Builder()
//                .addInterceptor(new Interceptor() {
//                    @Override
//                    public Response intercept(Chain chain) throws IOException {
//                        Request request = chain.request();
//                        Request.Builder builder = request.newBuilder();
//                        if (headMap != null && headMap.size() > 0) {
//                            Iterator<Map.Entry<String, String>> iterator = headMap.entrySet().iterator();
//                            while (iterator.hasNext()) {
//                                Map.Entry<String, String> entry = iterator.next();
//                                String key =  entry.getKey();
//                                String value = entry.getValue();
//                                builder.addHeader(key, value);
//                            }
//                        }
//                        return chain.proceed(builder.build());
//                    }
//                }).retryOnConnectionFailure(true)
//                .addInterceptor(new RetryInterceptor(retryCount))
//                .connectTimeout(timeout, TimeUnit.SECONDS)
//                .build();
//        return client;
    }

    private Retrofit.Builder mBuilder;

    public Api init(String baseUrl) {
        return init(baseUrl, 1, 40);
    }

    public Api init(String baseUrl, int retryCount, int timeout) {
        return init(baseUrl, retryCount, timeout, false);
    }

    private Retrofit mRetrofit;
    public Api init(String baseUrl, int retryCount, int timeout, boolean isCache) {
        mBuilder = new Retrofit.Builder()
                .baseUrl(baseUrl)
//                .addConverterFactory(ScalarsConverterFactory.create())
                .addConverterFactory(GsonConverterFactory.create())
                .addCallAdapterFactory(RxJava2CallAdapterFactory.create());

        mBuilder.client(addClient(retryCount, timeout, isCache));
        return this;
    }

    public Api build() {
        mRetrofit = mBuilder.build();
        return this;
    }

    public <T> T getService(final Class<T> serviceClass) {
        return mRetrofit.create(serviceClass);
    }

}
