/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.svrl;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.location.ILocation;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.diagnostics.error.AbstractSingleErrorBuilder;
import com.helger.diagnostics.error.IError;
import com.helger.diagnostics.error.SingleError;
import com.helger.diagnostics.error.level.IErrorLevel;
import com.helger.diagnostics.error.text.IHasErrorText;
import java.time.LocalDateTime;
import java.util.Locale;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class SVRLResourceError
extends SingleError {
    private final String m_sTest;

    public SVRLResourceError(@Nullable LocalDateTime localDateTime, @NonNull IErrorLevel iErrorLevel, @Nullable String string, @Nullable String string2, @Nullable ILocation iLocation, @Nullable IHasErrorText iHasErrorText, @Nullable Throwable throwable, @NonNull String string3) {
        super(localDateTime, iErrorLevel, string, string2, iLocation, iHasErrorText, throwable);
        this.m_sTest = (String)ValueEnforcer.notNull((Object)string3, (String)"Test");
    }

    public @NonNull String getTest() {
        return this.m_sTest;
    }

    public String getAsString(@NonNull Locale locale) {
        StringBuilder stringBuilder = new StringBuilder().append(super.getAsString(locale));
        stringBuilder.append(" Test=").append(this.m_sTest);
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        SVRLResourceError sVRLResourceError = (SVRLResourceError)((Object)object);
        return this.m_sTest.equals(sVRLResourceError.m_sTest);
    }

    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append((Object)this.m_sTest).getHashCode();
    }

    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("Test", (Object)this.m_sTest).getToString();
    }

    public static class SVRLErrorBuilder
    extends AbstractSingleErrorBuilder<SVRLResourceError, SVRLErrorBuilder> {
        private String m_sTest;

        public SVRLErrorBuilder(@NonNull String string) {
            this.test(string);
        }

        public SVRLErrorBuilder(@NonNull IError iError) {
            super(iError);
            if (iError instanceof SVRLResourceError) {
                this.test(((SVRLResourceError)iError).getTest());
            }
        }

        public final @NonNull SVRLErrorBuilder test(@NonNull String string) {
            this.m_sTest = (String)ValueEnforcer.notNull((Object)string, (String)"Test");
            return this;
        }

        public SVRLResourceError build() {
            return new SVRLResourceError(this.m_aErrorDT, this.m_aErrorLevel, this.m_sErrorID, this.m_sErrorFieldName, this.m_aErrorLocation, this.m_aErrorText, this.m_aLinkedException, this.m_sTest);
        }
    }
}

